/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.directives;

import io.sundr.Function;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.utils.StringUtils;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Modifier;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class FieldDirective
extends Directive {
    public String getName() {
        return "field";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        String block = "";
        JavaProperty field = null;
        if (node.jjtGetChild(0) != null) {
            field = (JavaProperty)node.jjtGetChild(0).value(context);
        }
        this.writeField(writer, field, block);
        return true;
    }

    private void writeField(Writer writer, JavaProperty field, String block) throws IOException {
        if (field != null) {
            writer.append(JavaPropertyToString.INSTANCE.apply(field));
            if (field.getType().getDefaultImplementation() != null) {
                JavaType defaultImpl = field.getType().getDefaultImplementation();
                writer.append(" = new ").append(JavaTypeToString.INSTANCE.apply(defaultImpl)).append("()");
            }
        }
        writer.append(";");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JavaPropertyToString implements Function<JavaProperty, String>
    {
        INSTANCE;


        public String apply(JavaProperty item) {
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtils.join(item.getModifiers(), ModifierToString.INSTANCE, " ")).append(" ");
            sb.append(item.getType().getSimpleName()).append(" ").append(item.getName());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JavaTypeToString implements Function<JavaType, String>
    {
        INSTANCE;


        public String apply(JavaType item) {
            return item.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ModifierToString implements Function<Modifier, String>
    {
        INSTANCE;


        public String apply(Modifier modifier) {
            return modifier.name().toLowerCase();
        }
    }
}

