/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.directives;

import io.sundr.Function;
import io.sundr.builder.Visitor;
import io.sundr.codegen.model.EditableJavaProperty;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.lang.model.element.Modifier;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.Node;

public class MethodDirective
extends Directive {
    public String getName() {
        return "method";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        String block = "";
        JavaMethod method = null;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) == null) continue;
            if (!(node.jjtGetChild(i) instanceof ASTBlock)) {
                if (i != 0) break;
                method = (JavaMethod)node.jjtGetChild(i).value(context);
                continue;
            }
            StringWriter blockContent = new StringWriter();
            node.jjtGetChild(i).render(context, (Writer)blockContent);
            block = blockContent.toString();
            break;
        }
        this.writeMethod(writer, method, block);
        return true;
    }

    private void writeMethod(Writer writer, JavaMethod method, String block) throws IOException {
        if (method != null) {
            writer.append(StringUtils.join(method.getModifiers(), ModifierToString.INSTANCE, " ")).append(" ");
            if (method.getTypeParameters() != null && !method.getTypeParameters().isEmpty()) {
                writer.append("<").append(StringUtils.join(method.getTypeParameters(), JavaTypeToString.INSTANCE, ", ")).append("> ");
            }
            writer.append(method.getReturnType().getSimpleName()).append(" ").append(method.getName()).append("(").append(this.methodArguments(method.getArguments())).append(")");
            this.writeExceptions(writer, method);
            if (!StringUtils.isNullOrEmpty(block)) {
                writer.append("{\n");
                writer.append(block).append("}\n");
            } else {
                writer.append(";");
            }
        }
    }

    private void writeExceptions(Writer writer, JavaMethod method) throws IOException {
        if (method.getExceptions().size() > 0) {
            writer.append(" throws ").append(StringUtils.join(method.getExceptions(), ""));
        }
    }

    private String methodArguments(JavaProperty[] arguments) {
        if (arguments.length == 0) {
            return "";
        }
        int lastIndex = arguments.length - 1;
        if (arguments[lastIndex].isArray()) {
            JavaProperty[] pre = new JavaProperty[arguments.length - 1];
            System.arraycopy(arguments, 0, pre, 0, arguments.length - 1);
            EditableJavaProperty varArg = ((JavaPropertyBuilder)new JavaPropertyBuilder(arguments[lastIndex]).accept(new Visitor(){

                public void visit(Object element) {
                    if (element instanceof JavaTypeBuilder) {
                        ((JavaTypeBuilder)((Object)element)).withArray(false);
                    }
                }
            })).build();
            return StringUtils.join(pre, JavaPropertyToString.INSTANCE, ", ") + VarArgPropertyToString.INSTANCE.apply(varArg);
        }
        return StringUtils.join(arguments, JavaPropertyToString.INSTANCE, ", ");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VarArgPropertyToString implements Function<JavaProperty, String>
    {
        INSTANCE;


        public String apply(JavaProperty item) {
            StringBuilder sb = new StringBuilder();
            String propertyType = item.getType().getSimpleName();
            sb.append(StringUtils.join(item.getModifiers(), ModifierToString.INSTANCE, " ")).append(" ");
            sb.append(propertyType).append(" ...").append(item.getName());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JavaPropertyToString implements Function<JavaProperty, String>
    {
        INSTANCE;


        public String apply(JavaProperty item) {
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtils.join(item.getModifiers(), ModifierToString.INSTANCE, " ")).append(" ");
            sb.append(item.getType().getSimpleName()).append(" ").append(item.getName());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JavaTypeToString implements Function<JavaType, String>
    {
        INSTANCE;


        public String apply(JavaType item) {
            return item.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ModifierToString implements Function<Modifier, String>
    {
        INSTANCE;


        public String apply(Modifier modifier) {
            return modifier.name().toLowerCase();
        }
    }
}

