/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dependency;

import io.sundr.Function;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalSort<T> {
    private final Function<T, Set<T>> collectDependencies;

    public TopologicalSort(Function<T, Set<T>> collectDependencies) {
        this.collectDependencies = collectDependencies;
    }

    public Set<T> sort(Iterable<T> items) {
        LinkedHashSet sorted = new LinkedHashSet();
        LinkedHashSet visited = new LinkedHashSet();
        for (T e : items) {
            this.visit(e, visited, sorted);
        }
        return sorted;
    }

    public void visit(T item, Set<T> visited, Set<T> sorted) {
        if (!visited.add(item)) {
            return;
        }
        for (T t : this.collectDependencies.apply(item)) {
            this.visit(t, visited, sorted);
        }
        sorted.add(item);
    }

    public Set<T> collectDependencies(T item) {
        return this.collectDependencies.apply(item);
    }
}

