/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.features.BeanValidationFeatures;
import io.swagger.codegen.v3.generators.features.GzipTestFeatures;
import io.swagger.codegen.v3.generators.features.LoggingTestFeatures;
import io.swagger.codegen.v3.generators.features.UseGenericResponseFeatures;
import io.swagger.codegen.v3.generators.java.AbstractJavaCodegen;
import io.swagger.codegen.v3.generators.java.AbstractJavaJAXRSServerCodegen;
import io.swagger.v3.oas.models.Operation;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCXFClientCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
UseGenericResponseFeatures,
GzipTestFeatures,
LoggingTestFeatures {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaCXFClientCodegen.class);
    protected static final String JAXRS_TEMPLATE_DIRECTORY_NAME = "JavaJaxRS";
    protected boolean useBeanValidation = false;
    protected boolean useGenericResponse = false;
    protected boolean useGzipFeatureForTests = false;
    protected boolean useLoggingFeatureForTests = false;

    public JavaCXFClientCodegen() {
        this.supportsInheritance = true;
        this.sourceFolder = "src/gen/java";
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-jaxrs-client";
        this.dateLibrary = "legacy";
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.outputFolder = "generated-code/JavaJaxRS-CXF";
        this.typeMapping.put("date", "LocalDate");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations"));
        this.cliOptions.add(CliOption.newBoolean((String)"useGzipFeatureForTests", (String)"Use Gzip Feature for tests"));
        this.cliOptions.add(CliOption.newBoolean((String)"useLoggingFeatureForTests", (String)"Use Logging Feature for tests"));
        this.cliOptions.add(CliOption.newBoolean((String)"useGenericResponse", (String)"Use generic response"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isBlank((CharSequence)this.templateDir)) {
            this.embeddedTemplateDir = this.templateDir = this.getTemplateDir();
        }
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            boolean useBeanValidationProp = this.convertPropertyToBooleanAndWriteBack("useBeanValidation");
            this.setUseBeanValidation(useBeanValidationProp);
        }
        if (this.additionalProperties.containsKey("useGenericResponse")) {
            this.setUseGenericResponse(this.convertPropertyToBoolean("useGenericResponse"));
        }
        if (this.useGenericResponse) {
            this.writePropertyBack("useGenericResponse", this.useGenericResponse);
        }
        this.setUseGzipFeatureForTests(this.convertPropertyToBooleanAndWriteBack("useGzipFeatureForTests"));
        this.setUseLoggingFeatureForTests(this.convertPropertyToBooleanAndWriteBack("useLoggingFeatureForTests"));
        this.supportingFiles.clear();
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
    }

    public String getName() {
        return "jaxrs-cxf-client";
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        co.subresourceOperation = !co.path.isEmpty();
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (this.useOas2) {
            model.imports.remove("ApiModelProperty");
            model.imports.remove("ApiModel");
        } else {
            model.imports.remove("Schema");
        }
        model.imports.remove("JsonSerialize");
        model.imports.remove("ToStringSerializer");
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        objs = super.postProcessOperations(objs);
        return AbstractJavaJAXRSServerCodegen.jaxrsPostProcessOperations(objs);
    }

    public String getHelp() {
        return "[WORK IN PROGRESS: generated code depends from Swagger v2 libraries] Generates a Java JAXRS Client based on Apache CXF framework.";
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setUseGzipFeatureForTests(boolean useGzipFeatureForTests) {
        this.useGzipFeatureForTests = useGzipFeatureForTests;
    }

    @Override
    public void setUseLoggingFeatureForTests(boolean useLoggingFeatureForTests) {
        this.useLoggingFeatureForTests = useLoggingFeatureForTests;
    }

    @Override
    public void setUseGenericResponse(boolean useGenericResponse) {
        this.useGenericResponse = useGenericResponse;
    }

    @Override
    public String getArgumentsLocation() {
        return "";
    }

    @Override
    public String getDefaultTemplateDir() {
        return "JavaJaxRS/cxf";
    }
}

