/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins;

import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.util.AetherUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class Deploy
extends TakariLifecycleMojo {
    @Override
    public void executeMojo() throws MojoExecutionException {
        this.installProject(this.project);
    }

    private void installProject(MavenProject project) throws MojoExecutionException {
        Artifact artifact;
        DeployRequest deployRequest = new DeployRequest();
        if ("pom".equals(project.getPackaging())) {
            artifact = AetherUtils.toArtifact(project.getArtifact());
            artifact = artifact.setFile(project.getFile());
            deployRequest.addArtifact(artifact);
        } else {
            artifact = AetherUtils.toArtifact(project.getArtifact());
            deployRequest.addArtifact(artifact);
            SubArtifact pomArtifact = new SubArtifact(artifact, "", "pom");
            pomArtifact = pomArtifact.setFile(project.getFile());
            deployRequest.addArtifact((Artifact)pomArtifact);
        }
        for (org.apache.maven.artifact.Artifact attachedArtifact : project.getAttachedArtifacts()) {
            deployRequest.addArtifact(AetherUtils.toArtifact(attachedArtifact));
        }
        deployRequest.setRepository(this.remoteRepository(project));
        try {
            this.repositorySystem.deploy(this.repositorySystemSession, deployRequest);
        }
        catch (DeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public RemoteRepository remoteRepository(MavenProject project) {
        return AetherUtils.toRepo(project.getDistributionManagementArtifactRepository());
    }
}

