/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.install_deploy;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DeployParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Logger log = LoggerFactory.getLogger(AbstractMavenLifecycleParticipant.class);
    protected RepositorySystem repoSystem;
    private List<DeployRequest> deployAtEndRequests = Collections.synchronizedList(new ArrayList());

    @Inject
    public DeployParticipant(RepositorySystem repoSystem) {
        this.repoSystem = repoSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        boolean errors;
        boolean bl = errors = !session.getResult().getExceptions().isEmpty();
        if (!this.deployAtEndRequests.isEmpty()) {
            log.info("");
            log.info("------------------------------------------------------------------------");
            if (errors) {
                log.info("-- Not performing deploy at end due to errors                         --");
            } else {
                log.info("-- Performing deploy at end                                           --");
                log.info("------------------------------------------------------------------------");
                List<DeployRequest> list = this.deployAtEndRequests;
                synchronized (list) {
                    for (DeployRequest deployRequest : this.deployAtEndRequests) {
                        try {
                            this.deploy(session.getRepositorySession(), deployRequest);
                        }
                        catch (DeploymentException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
                        }
                    }
                    this.deployAtEndRequests.clear();
                }
            }
            log.info("------------------------------------------------------------------------");
        }
    }

    List<DeployRequest> getDeployAtEndRequests() {
        return Collections.unmodifiableList(this.deployAtEndRequests);
    }

    public void deploy(RepositorySystemSession session, DeployRequest deployRequest) throws DeploymentException {
        this.repoSystem.deploy(session, deployRequest);
    }

    public void deployAtEnd(DeployRequest deployRequest) {
        this.checkSupport();
        this.deployAtEndRequests.add(deployRequest);
    }

    private void checkSupport() {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = Maven.class.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
                if (in != null) {
                    properties.load(in);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Unable determine maven version, deploy at end might fail", (Throwable)e);
            return;
        }
        String mavenVersion = properties.getProperty("version");
        if (mavenVersion != null) {
            int c = new DefaultArtifactVersion(mavenVersion).compareTo((ArtifactVersion)new DefaultArtifactVersion("3.3.1"));
            if (c < 0) {
                throw new IllegalStateException("Deploy-at-end is not supported on maven versions <3.3.1");
            }
        } else {
            log.error("Unable determine maven version, deploy at end might fail");
        }
    }
}

