/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.pgp;

import io.takari.jpgp.PgpArtifactSigner;
import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.pgp.SigningBundle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="signArtifact", configurator="takari", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SignArtifactMojo
extends TakariLifecycleMojo {
    public static final String SIGNATURE_EXTENSION = ".asc";
    private final Logger logger = LoggerFactory.getLogger(SignArtifactMojo.class);
    @Parameter(property="gpg.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="gpg.passphrase")
    private String passphrase;

    @Override
    protected void executeMojo() throws MojoExecutionException {
        if (this.skip) {
            this.logger.info("Skipping PGP signature generation as per configuration.");
            return;
        }
        ArrayList<SigningBundle> signingBundles = new ArrayList<SigningBundle>();
        if (!"pom".equals(this.project.getPackaging())) {
            Artifact artifact = this.project.getArtifact();
            File file = artifact.getFile();
            if (file == null) {
                this.logger.info("There is no artifact present. Make sure you run this after the package phase.");
                return;
            }
            File projectArtifactSignature = this.sign(file);
            if (projectArtifactSignature != null) {
                signingBundles.add(new SigningBundle(artifact.getArtifactHandler().getExtension(), projectArtifactSignature));
            }
        }
        File pomToSign = new File(this.project.getBuild().getDirectory(), String.valueOf(this.project.getBuild().getFinalName()) + ".pom");
        try {
            Files.createDirectories(pomToSign.getParentFile().toPath(), new FileAttribute[0]);
            Files.copy(this.project.getFile().toPath(), pomToSign.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying POM for signing.", (Exception)e);
        }
        File pomSignature = this.sign(pomToSign);
        if (pomSignature != null) {
            signingBundles.add(new SigningBundle("pom", pomSignature));
        }
        for (Artifact a : this.project.getAttachedArtifacts()) {
            File signatureFile = this.sign(a.getFile());
            if (signatureFile == null) continue;
            signingBundles.add(new SigningBundle(a.getArtifactHandler().getExtension(), a.getClassifier(), signatureFile));
        }
        for (SigningBundle bundle : signingBundles) {
            this.projectHelper.attachArtifact(this.project, String.valueOf(bundle.getExtension()) + SIGNATURE_EXTENSION, bundle.getClassifier(), bundle.getSignature());
        }
    }

    private File sign(File file) throws MojoExecutionException {
        try {
            PgpArtifactSigner signer = new PgpArtifactSigner();
            if (this.passphrase != null) {
                return signer.sign(file, this.passphrase);
            }
            return signer.sign(file);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error signing artifact " + file + ".", e);
        }
    }
}

