/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.client.schedules.ScheduleAction;
import io.temporal.client.schedules.SchedulePolicy;
import io.temporal.client.schedules.ScheduleSpec;
import io.temporal.client.schedules.ScheduleState;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Schedule {
    private final ScheduleAction action;
    private final SchedulePolicy policy;
    private final ScheduleState state;
    private final ScheduleSpec spec;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Schedule options) {
        return new Builder(options);
    }

    private Schedule(ScheduleAction action, ScheduleSpec spec, SchedulePolicy policy, ScheduleState state) {
        this.action = action;
        this.spec = spec;
        this.policy = policy;
        this.state = state;
    }

    @Nonnull
    public ScheduleAction getAction() {
        return this.action;
    }

    @Nonnull
    public ScheduleSpec getSpec() {
        return this.spec;
    }

    @Nullable
    public SchedulePolicy getPolicy() {
        return this.policy;
    }

    @Nullable
    public ScheduleState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schedule schedule = (Schedule)o;
        return Objects.equals(this.action, schedule.action) && Objects.equals(this.policy, schedule.policy) && Objects.equals(this.state, schedule.state) && Objects.equals(this.spec, schedule.spec);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.policy, this.state, this.spec);
    }

    public String toString() {
        return "Schedule{action=" + this.action + ", policy=" + this.policy + ", state=" + this.state + ", spec=" + this.spec + '}';
    }

    public static final class Builder {
        private ScheduleAction action;
        private ScheduleSpec spec;
        private SchedulePolicy policy;
        private ScheduleState state;

        private Builder() {
        }

        private Builder(Schedule options) {
            if (options == null) {
                return;
            }
            this.action = options.action;
            this.policy = options.policy;
            this.state = options.state;
            this.spec = options.spec;
        }

        public Builder setAction(ScheduleAction action) {
            this.action = action;
            return this;
        }

        public Builder setSpec(ScheduleSpec spec) {
            this.spec = spec;
            return this;
        }

        public Builder setPolicy(SchedulePolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder setState(ScheduleState state) {
            this.state = state;
            return this;
        }

        public Schedule build() {
            return new Schedule(Objects.requireNonNull(this.action), Objects.requireNonNull(this.spec), this.policy, this.state);
        }
    }
}

