/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import com.google.common.base.Preconditions;
import io.temporal.api.enums.v1.ScheduleOverlapPolicy;
import io.temporal.client.schedules.ScheduleBackfill;
import io.temporal.client.schedules.ScheduleDescription;
import io.temporal.client.schedules.ScheduleHandle;
import io.temporal.client.schedules.ScheduleUpdate;
import io.temporal.client.schedules.ScheduleUpdateInput;
import io.temporal.common.interceptors.ScheduleClientCallsInterceptor;
import io.temporal.workflow.Functions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

class ScheduleHandleImpl
implements ScheduleHandle {
    private final String Id;
    private final ScheduleClientCallsInterceptor interceptor;

    public ScheduleHandleImpl(ScheduleClientCallsInterceptor interceptor, String Id) {
        this.interceptor = interceptor;
        this.Id = Id;
    }

    @Override
    public String getId() {
        return this.Id;
    }

    @Override
    public void backfill(List<ScheduleBackfill> backfills) {
        Preconditions.checkState((backfills.size() > 0 ? 1 : 0) != 0, (Object)"At least one backfill required");
        this.interceptor.backfillSchedule(new ScheduleClientCallsInterceptor.BackfillScheduleInput(this.Id, backfills));
    }

    @Override
    public void delete() {
        this.interceptor.deleteSchedule(new ScheduleClientCallsInterceptor.DeleteScheduleInput(this.Id));
    }

    @Override
    public ScheduleDescription describe() {
        return this.interceptor.describeSchedule(new ScheduleClientCallsInterceptor.DescribeScheduleInput(this.Id)).getDescription();
    }

    @Override
    public void pause(@Nonnull String note) {
        Objects.requireNonNull(note);
        this.interceptor.pauseSchedule(new ScheduleClientCallsInterceptor.PauseScheduleInput(this.Id, note.isEmpty() ? "Paused via Java SDK" : note));
    }

    @Override
    public void pause() {
        this.pause("");
    }

    @Override
    public void trigger(ScheduleOverlapPolicy overlapPolicy) {
        this.interceptor.triggerSchedule(new ScheduleClientCallsInterceptor.TriggerScheduleInput(this.Id, overlapPolicy));
    }

    @Override
    public void trigger() {
        this.interceptor.triggerSchedule(new ScheduleClientCallsInterceptor.TriggerScheduleInput(this.Id, ScheduleOverlapPolicy.SCHEDULE_OVERLAP_POLICY_UNSPECIFIED));
    }

    @Override
    public void unpause(@Nonnull String note) {
        Objects.requireNonNull(note);
        this.interceptor.unpauseSchedule(new ScheduleClientCallsInterceptor.UnpauseScheduleInput(this.Id, note.isEmpty() ? "Unpaused via Java SDK" : note));
    }

    @Override
    public void unpause() {
        this.unpause("");
    }

    @Override
    public void update(Functions.Func1<ScheduleUpdateInput, ScheduleUpdate> updater) {
        this.interceptor.updateSchedule(new ScheduleClientCallsInterceptor.UpdateScheduleInput(this.describe(), updater));
    }
}

