/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.failure.v1.Failure;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.FailureConverter;
import io.temporal.common.converter.PayloadConverter;
import io.temporal.failure.DefaultFailureConverter;
import io.temporal.failure.TemporalFailure;
import io.temporal.payload.context.SerializationContext;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class PayloadAndFailureDataConverter
implements DataConverter {
    volatile List<PayloadConverter> converters;
    volatile Map<String, PayloadConverter> convertersMap;
    volatile FailureConverter failureConverter;
    @Nullable
    private final SerializationContext serializationContext;

    public PayloadAndFailureDataConverter(@Nonnull List<PayloadConverter> converters) {
        this(Collections.unmodifiableList(converters), PayloadAndFailureDataConverter.createConvertersMap(converters), new DefaultFailureConverter(), null);
    }

    PayloadAndFailureDataConverter(@Nonnull List<PayloadConverter> converters, @Nonnull Map<String, PayloadConverter> convertersMap, @Nonnull FailureConverter failureConverter, @Nullable SerializationContext serializationContext) {
        this.failureConverter = (FailureConverter)Preconditions.checkNotNull((Object)failureConverter, (Object)"failureConverter");
        this.converters = (List)Preconditions.checkNotNull(converters, (Object)"converters");
        this.convertersMap = (Map)Preconditions.checkNotNull(convertersMap, (Object)"converterMap");
        this.serializationContext = serializationContext;
    }

    @Override
    public <T> Optional<Payload> toPayload(T value) throws DataConverterException {
        for (PayloadConverter converter : this.converters) {
            Optional<Payload> result = (this.serializationContext != null ? converter.withContext(this.serializationContext) : converter).toData(value);
            if (!result.isPresent()) continue;
            return result;
        }
        throw new DataConverterException("No PayloadConverter is registered with this DataConverter that accepts value:" + value);
    }

    @Override
    public <T> T fromPayload(Payload payload, Class<T> valueClass, Type valueType) throws DataConverterException {
        try {
            String encoding = payload.getMetadataOrThrow("encoding").toString(StandardCharsets.UTF_8);
            PayloadConverter converter = this.convertersMap.get(encoding);
            if (converter == null) {
                throw new DataConverterException("No PayloadConverter is registered for an encoding: " + encoding);
            }
            return (this.serializationContext != null ? converter.withContext(this.serializationContext) : converter).fromData(payload, valueClass, valueType);
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataConverterException(payload, valueClass, (Throwable)e);
        }
    }

    @Override
    public Optional<Payloads> toPayloads(Object ... values) throws DataConverterException {
        if (values == null || values.length == 0) {
            return Optional.empty();
        }
        try {
            Payloads.Builder result = Payloads.newBuilder();
            for (Object value : values) {
                result.addPayloads(this.toPayload(value).get());
            }
            return Optional.of(result.build());
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DataConverterException(e);
        }
    }

    @Override
    public <T> T fromPayloads(int index, Optional<Payloads> content, Class<T> parameterType, Type genericParameterType) throws DataConverterException {
        if (!content.isPresent()) {
            return (T)Defaults.defaultValue(parameterType);
        }
        int count = content.get().getPayloadsCount();
        if (index >= count) {
            return (T)Defaults.defaultValue(parameterType);
        }
        return this.fromPayload(content.get().getPayloads(index), parameterType, genericParameterType);
    }

    @Override
    @Nonnull
    public TemporalFailure failureToException(@Nonnull Failure failure) {
        Preconditions.checkNotNull((Object)failure, (Object)"failure");
        return (this.serializationContext != null ? this.failureConverter.withContext(this.serializationContext) : this.failureConverter).failureToException(failure, this);
    }

    @Override
    @Nonnull
    public Failure exceptionToFailure(@Nonnull Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable, (Object)"throwable");
        return (this.serializationContext != null ? this.failureConverter.withContext(this.serializationContext) : this.failureConverter).exceptionToFailure(throwable, this);
    }

    @Override
    @Nonnull
    public DataConverter withContext(@Nonnull SerializationContext context) {
        return new PayloadAndFailureDataConverter(this.converters, this.convertersMap, this.failureConverter, context);
    }

    static Map<String, PayloadConverter> createConvertersMap(List<PayloadConverter> converters) {
        HashMap<String, PayloadConverter> newConverterMap = new HashMap<String, PayloadConverter>();
        for (PayloadConverter converter : converters) {
            newConverterMap.put(converter.getEncodingType(), converter);
        }
        return newConverterMap;
    }
}

