/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.interceptors;

import io.temporal.api.enums.v1.ScheduleOverlapPolicy;
import io.temporal.client.schedules.Schedule;
import io.temporal.client.schedules.ScheduleBackfill;
import io.temporal.client.schedules.ScheduleDescription;
import io.temporal.client.schedules.ScheduleListDescription;
import io.temporal.client.schedules.ScheduleOptions;
import io.temporal.client.schedules.ScheduleUpdate;
import io.temporal.client.schedules.ScheduleUpdateInput;
import io.temporal.common.Experimental;
import io.temporal.workflow.Functions;
import java.util.List;
import java.util.stream.Stream;

@Experimental
public interface ScheduleClientCallsInterceptor {
    public void createSchedule(CreateScheduleInput var1);

    public ListScheduleOutput listSchedules(ListSchedulesInput var1);

    public void backfillSchedule(BackfillScheduleInput var1);

    public void deleteSchedule(DeleteScheduleInput var1);

    public DescribeScheduleOutput describeSchedule(DescribeScheduleInput var1);

    public void pauseSchedule(PauseScheduleInput var1);

    public void triggerSchedule(TriggerScheduleInput var1);

    public void unpauseSchedule(UnpauseScheduleInput var1);

    public void updateSchedule(UpdateScheduleInput var1);

    public static class UpdateScheduleInput {
        private final ScheduleDescription description;
        private final Functions.Func1<ScheduleUpdateInput, ScheduleUpdate> updater;

        public ScheduleDescription getDescription() {
            return this.description;
        }

        public Functions.Func1<ScheduleUpdateInput, ScheduleUpdate> getUpdater() {
            return this.updater;
        }

        public UpdateScheduleInput(ScheduleDescription description, Functions.Func1<ScheduleUpdateInput, ScheduleUpdate> updater) {
            this.description = description;
            this.updater = updater;
        }
    }

    public static class UnpauseScheduleInput {
        private final String scheduleId;
        private final String note;

        public String getScheduleId() {
            return this.scheduleId;
        }

        public String getNote() {
            return this.note;
        }

        public UnpauseScheduleInput(String scheduleId, String note) {
            this.scheduleId = scheduleId;
            this.note = note;
        }
    }

    public static class TriggerScheduleInput {
        private final String scheduleId;
        private final ScheduleOverlapPolicy overlapPolicy;

        public String getScheduleId() {
            return this.scheduleId;
        }

        public ScheduleOverlapPolicy getOverlapPolicy() {
            return this.overlapPolicy;
        }

        public TriggerScheduleInput(String scheduleId, ScheduleOverlapPolicy overlapPolicy) {
            this.scheduleId = scheduleId;
            this.overlapPolicy = overlapPolicy;
        }
    }

    public static class PauseScheduleInput {
        private final String scheduleId;
        private final String note;

        public String getScheduleId() {
            return this.scheduleId;
        }

        public String getNote() {
            return this.note;
        }

        public PauseScheduleInput(String scheduleId, String note) {
            this.scheduleId = scheduleId;
            this.note = note;
        }
    }

    public static class DescribeScheduleOutput {
        private final ScheduleDescription description;

        public DescribeScheduleOutput(ScheduleDescription description) {
            this.description = description;
        }

        public ScheduleDescription getDescription() {
            return this.description;
        }
    }

    public static class DescribeScheduleInput {
        private final String scheduleId;

        public String getScheduleId() {
            return this.scheduleId;
        }

        public DescribeScheduleInput(String scheduleId) {
            this.scheduleId = scheduleId;
        }
    }

    public static class DeleteScheduleInput {
        private final String scheduleId;

        public String getScheduleId() {
            return this.scheduleId;
        }

        public DeleteScheduleInput(String scheduleId) {
            this.scheduleId = scheduleId;
        }
    }

    public static class BackfillScheduleInput {
        private final String scheduleId;
        private final List<ScheduleBackfill> backfills;

        public String getScheduleId() {
            return this.scheduleId;
        }

        public List<ScheduleBackfill> getBackfills() {
            return this.backfills;
        }

        public BackfillScheduleInput(String scheduleId, List<ScheduleBackfill> backfills) {
            this.scheduleId = scheduleId;
            this.backfills = backfills;
        }
    }

    public static class ListScheduleOutput {
        private final Stream<ScheduleListDescription> stream;

        public Stream<ScheduleListDescription> getStream() {
            return this.stream;
        }

        public ListScheduleOutput(Stream<ScheduleListDescription> stream) {
            this.stream = stream;
        }
    }

    public static class ListSchedulesInput {
        private final int pageSize;

        public ListSchedulesInput(int pageSize) {
            this.pageSize = pageSize;
        }

        public int getPageSize() {
            return this.pageSize;
        }
    }

    public static class CreateScheduleInput {
        private final String Id;
        private final Schedule schedule;
        private final ScheduleOptions options;

        public CreateScheduleInput(String id, Schedule schedule, ScheduleOptions options) {
            this.Id = id;
            this.schedule = schedule;
            this.options = options;
        }

        public String getId() {
            return this.Id;
        }

        public Schedule getSchedule() {
            return this.schedule;
        }

        public ScheduleOptions getOptions() {
            return this.options;
        }
    }
}

