/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client.external;

import com.google.common.util.concurrent.ListenableFuture;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.grpc.Deadline;
import io.temporal.api.workflowservice.v1.CreateScheduleRequest;
import io.temporal.api.workflowservice.v1.CreateScheduleResponse;
import io.temporal.api.workflowservice.v1.DeleteScheduleRequest;
import io.temporal.api.workflowservice.v1.DeleteScheduleResponse;
import io.temporal.api.workflowservice.v1.DescribeScheduleRequest;
import io.temporal.api.workflowservice.v1.DescribeScheduleResponse;
import io.temporal.api.workflowservice.v1.GetWorkerBuildIdCompatibilityRequest;
import io.temporal.api.workflowservice.v1.GetWorkerBuildIdCompatibilityResponse;
import io.temporal.api.workflowservice.v1.GetWorkerTaskReachabilityRequest;
import io.temporal.api.workflowservice.v1.GetWorkerTaskReachabilityResponse;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.ListSchedulesRequest;
import io.temporal.api.workflowservice.v1.ListSchedulesResponse;
import io.temporal.api.workflowservice.v1.ListWorkflowExecutionsRequest;
import io.temporal.api.workflowservice.v1.ListWorkflowExecutionsResponse;
import io.temporal.api.workflowservice.v1.PatchScheduleRequest;
import io.temporal.api.workflowservice.v1.PatchScheduleResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowExecutionUpdateRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowExecutionUpdateResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.UpdateScheduleRequest;
import io.temporal.api.workflowservice.v1.UpdateScheduleResponse;
import io.temporal.api.workflowservice.v1.UpdateWorkerBuildIdCompatibilityRequest;
import io.temporal.api.workflowservice.v1.UpdateWorkerBuildIdCompatibilityResponse;
import io.temporal.api.workflowservice.v1.UpdateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.UpdateWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.rpcretry.DefaultStubLongPollRpcRetryOptions;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Nonnull;

public final class GenericWorkflowClientImpl
implements GenericWorkflowClient {
    private static final ScheduledExecutorService asyncThrottlerExecutor = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "generic-wf-client-async-throttler"));
    private final WorkflowServiceStubs service;
    private final Scope metricsScope;
    private final GrpcRetryer grpcRetryer;
    private final GrpcRetryer.GrpcRetryerOptions grpcRetryerOptions;

    public GenericWorkflowClientImpl(WorkflowServiceStubs service, Scope metricsScope) {
        this.service = service;
        this.metricsScope = metricsScope;
        RpcRetryOptions rpcRetryOptions = RpcRetryOptions.newBuilder().buildWithDefaultsFrom(service.getOptions().getRpcRetryOptions());
        this.grpcRetryer = new GrpcRetryer(service.getServerCapabilities());
        this.grpcRetryerOptions = new GrpcRetryer.GrpcRetryerOptions(rpcRetryOptions, null);
    }

    @Override
    public StartWorkflowExecutionResponse start(StartWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"workflow_type", (Object)request.getWorkflowType().getName()).put((Object)"task_queue", (Object)request.getTaskQueue().getName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        return (StartWorkflowExecutionResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).startWorkflowExecution(request), this.grpcRetryerOptions);
    }

    @Override
    public void signal(SignalWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"signal_name", (Object)request.getSignalName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).signalWorkflowExecution(request), this.grpcRetryerOptions);
    }

    @Override
    public SignalWithStartWorkflowExecutionResponse signalWithStart(SignalWithStartWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"workflow_type", (Object)request.getWorkflowType().getName()).put((Object)"task_queue", (Object)request.getTaskQueue().getName()).put((Object)"signal_name", (Object)request.getSignalName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        return (SignalWithStartWorkflowExecutionResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).signalWithStartWorkflowExecution(request), this.grpcRetryerOptions);
    }

    @Override
    public void requestCancel(RequestCancelWorkflowExecutionRequest request) {
        this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).requestCancelWorkflowExecution(request), this.grpcRetryerOptions);
    }

    @Override
    public void terminate(TerminateWorkflowExecutionRequest request) {
        this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).terminateWorkflowExecution(request), this.grpcRetryerOptions);
    }

    @Override
    public GetWorkflowExecutionHistoryResponse longPollHistory(@Nonnull GetWorkflowExecutionHistoryRequest request, @Nonnull Deadline deadline) {
        return (GetWorkflowExecutionHistoryResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).withOption(MetricsTag.HISTORY_LONG_POLL_CALL_OPTIONS_KEY, (Object)true)).withDeadline(deadline)).getWorkflowExecutionHistory(request), new GrpcRetryer.GrpcRetryerOptions(DefaultStubLongPollRpcRetryOptions.INSTANCE, deadline));
    }

    @Override
    public CompletableFuture<GetWorkflowExecutionHistoryResponse> longPollHistoryAsync(@Nonnull GetWorkflowExecutionHistoryRequest request, @Nonnull Deadline deadline) {
        return this.grpcRetryer.retryWithResultAsync(asyncThrottlerExecutor, () -> GenericWorkflowClientImpl.toCompletableFuture(((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).withOption(MetricsTag.HISTORY_LONG_POLL_CALL_OPTIONS_KEY, (Object)true)).withDeadline(deadline)).getWorkflowExecutionHistory(request)), new GrpcRetryer.GrpcRetryerOptions(DefaultStubLongPollRpcRetryOptions.INSTANCE, deadline));
    }

    @Override
    public GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(@Nonnull GetWorkflowExecutionHistoryRequest request) {
        return (GetWorkflowExecutionHistoryResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).getWorkflowExecutionHistory(request), this.grpcRetryerOptions);
    }

    @Override
    public CompletableFuture<GetWorkflowExecutionHistoryResponse> getWorkflowExecutionHistoryAsync(@Nonnull GetWorkflowExecutionHistoryRequest request) {
        return this.grpcRetryer.retryWithResultAsync(asyncThrottlerExecutor, () -> GenericWorkflowClientImpl.toCompletableFuture(((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).getWorkflowExecutionHistory(request)), this.grpcRetryerOptions);
    }

    @Override
    public QueryWorkflowResponse query(QueryWorkflowRequest queryParameters) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"query_type", (Object)queryParameters.getQuery().getQueryType()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        return (QueryWorkflowResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).queryWorkflow(queryParameters), this.grpcRetryerOptions);
    }

    @Override
    public ListWorkflowExecutionsResponse listWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) {
        return (ListWorkflowExecutionsResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).listWorkflowExecutions(listRequest), this.grpcRetryerOptions);
    }

    @Override
    public CompletableFuture<ListWorkflowExecutionsResponse> listWorkflowExecutionsAsync(ListWorkflowExecutionsRequest listRequest) {
        return this.grpcRetryer.retryWithResultAsync(asyncThrottlerExecutor, () -> GenericWorkflowClientImpl.toCompletableFuture(((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).listWorkflowExecutions(listRequest)), this.grpcRetryerOptions);
    }

    @Override
    public CreateScheduleResponse createSchedule(CreateScheduleRequest request) {
        return (CreateScheduleResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).createSchedule(request), this.grpcRetryerOptions);
    }

    @Override
    public CompletableFuture<ListSchedulesResponse> listSchedulesAsync(ListSchedulesRequest request) {
        return this.grpcRetryer.retryWithResultAsync(asyncThrottlerExecutor, () -> GenericWorkflowClientImpl.toCompletableFuture(((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).listSchedules(request)), this.grpcRetryerOptions);
    }

    @Override
    public UpdateScheduleResponse updateSchedule(UpdateScheduleRequest request) {
        return (UpdateScheduleResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).updateSchedule(request), this.grpcRetryerOptions);
    }

    @Override
    public PatchScheduleResponse patchSchedule(PatchScheduleRequest request) {
        return (PatchScheduleResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).patchSchedule(request), this.grpcRetryerOptions);
    }

    @Override
    public DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest request) {
        return (DeleteScheduleResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).deleteSchedule(request), this.grpcRetryerOptions);
    }

    @Override
    public DescribeScheduleResponse describeSchedule(DescribeScheduleRequest request) {
        return (DescribeScheduleResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).describeSchedule(request), this.grpcRetryerOptions);
    }

    private static <T> CompletableFuture<T> toCompletableFuture(ListenableFuture<T> listenableFuture) {
        CompletableFuture result = new CompletableFuture();
        listenableFuture.addListener(() -> {
            try {
                result.complete(listenableFuture.get());
            }
            catch (ExecutionException e) {
                result.completeExceptionally(e.getCause());
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        }, (Executor)ForkJoinPool.commonPool());
        return result;
    }

    @Override
    public UpdateWorkflowExecutionResponse update(@Nonnull UpdateWorkflowExecutionRequest updateParameters, @Nonnull Deadline deadline) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"update_name", (Object)updateParameters.getRequest().getInput().getName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        return (UpdateWorkflowExecutionResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withDeadline(deadline)).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).updateWorkflowExecution(updateParameters), new GrpcRetryer.GrpcRetryerOptions(DefaultStubLongPollRpcRetryOptions.INSTANCE, deadline));
    }

    @Override
    public CompletableFuture<PollWorkflowExecutionUpdateResponse> pollUpdateAsync(@Nonnull PollWorkflowExecutionUpdateRequest request, @Nonnull Deadline deadline) {
        return this.grpcRetryer.retryWithResultAsync(asyncThrottlerExecutor, () -> GenericWorkflowClientImpl.toCompletableFuture(((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withDeadline(deadline)).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollWorkflowExecutionUpdate(request)), new GrpcRetryer.GrpcRetryerOptions(DefaultStubLongPollRpcRetryOptions.INSTANCE, deadline));
    }

    @Override
    public UpdateWorkerBuildIdCompatibilityResponse updateWorkerBuildIdCompatability(UpdateWorkerBuildIdCompatibilityRequest request) {
        return (UpdateWorkerBuildIdCompatibilityResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).updateWorkerBuildIdCompatibility(request), this.grpcRetryerOptions);
    }

    @Override
    public GetWorkerBuildIdCompatibilityResponse getWorkerBuildIdCompatability(GetWorkerBuildIdCompatibilityRequest req) {
        return (GetWorkerBuildIdCompatibilityResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).getWorkerBuildIdCompatibility(req), this.grpcRetryerOptions);
    }

    @Override
    public GetWorkerTaskReachabilityResponse GetWorkerTaskReachability(GetWorkerTaskReachabilityRequest req) {
        return (GetWorkerTaskReachabilityResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).getWorkerTaskReachability(req), this.grpcRetryerOptions);
    }
}

