/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.annotations.VisibleForTesting;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.common.MethodRetry;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.sync.ActivityInvocationHandlerBase;
import io.temporal.internal.sync.LocalActivityStubImpl;
import io.temporal.workflow.ActivityStub;
import io.temporal.workflow.Functions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@VisibleForTesting
public class LocalActivityInvocationHandler
extends ActivityInvocationHandlerBase {
    private final LocalActivityOptions options;
    private final Map<String, LocalActivityOptions> activityMethodOptions;
    private final WorkflowOutboundCallsInterceptor activityExecutor;
    private final Functions.Proc assertReadOnly;

    @VisibleForTesting
    public static InvocationHandler newInstance(Class<?> activityInterface, LocalActivityOptions options, Map<String, LocalActivityOptions> methodOptions, WorkflowOutboundCallsInterceptor activityExecutor, Functions.Proc assertReadOnly) {
        return new LocalActivityInvocationHandler(activityInterface, activityExecutor, options, methodOptions, assertReadOnly);
    }

    private LocalActivityInvocationHandler(Class<?> activityInterface, WorkflowOutboundCallsInterceptor activityExecutor, LocalActivityOptions options, Map<String, LocalActivityOptions> methodOptions, Functions.Proc assertReadOnly) {
        super(activityInterface);
        this.options = options;
        this.activityMethodOptions = methodOptions == null ? new HashMap() : methodOptions;
        this.activityExecutor = activityExecutor;
        this.assertReadOnly = assertReadOnly;
    }

    @Override
    @VisibleForTesting
    public Function<Object[], Object> getActivityFunc(Method method, MethodRetry methodRetry, String activityName) {
        LocalActivityOptions mergedOptions = LocalActivityOptions.newBuilder(this.options).mergeActivityOptions(this.activityMethodOptions.get(activityName)).setMethodRetry(methodRetry).build();
        ActivityStub stub = LocalActivityStubImpl.newInstance(mergedOptions, this.activityExecutor, this.assertReadOnly);
        Function<Object[], Object> function = a -> stub.execute(activityName, method.getReturnType(), method.getGenericReturnType(), a);
        return function;
    }
}

