/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.base.Preconditions;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributesOrBuilder;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedResponse;
import io.temporal.internal.Config;
import io.temporal.internal.worker.EagerActivityDispatcher;
import java.io.Closeable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class EagerActivitySlotsReservation
implements Closeable {
    private final EagerActivityDispatcher eagerActivityDispatcher;
    private int outstandingReservationSlotsCount = 0;

    EagerActivitySlotsReservation(EagerActivityDispatcher eagerActivityDispatcher) {
        this.eagerActivityDispatcher = eagerActivityDispatcher;
    }

    public void applyToRequest(RespondWorkflowTaskCompletedRequest.Builder mutableRequest) {
        for (int i = 0; i < mutableRequest.getCommandsCount(); ++i) {
            ScheduleActivityTaskCommandAttributes commandAttributes;
            Command command = mutableRequest.getCommands(i);
            if (command.getCommandType() != CommandType.COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK || !(commandAttributes = command.getScheduleActivityTaskCommandAttributes()).getRequestEagerExecution()) continue;
            if (this.outstandingReservationSlotsCount < Config.EAGER_ACTIVITIES_LIMIT && this.eagerActivityDispatcher.tryReserveActivitySlot((ScheduleActivityTaskCommandAttributesOrBuilder)commandAttributes)) {
                ++this.outstandingReservationSlotsCount;
                continue;
            }
            mutableRequest.setCommands(i, command.toBuilder().setScheduleActivityTaskCommandAttributes(commandAttributes.toBuilder().setRequestEagerExecution(false)));
        }
    }

    public void handleResponse(RespondWorkflowTaskCompletedResponse serverResponse) {
        int activityTasksCount = serverResponse.getActivityTasksCount();
        Preconditions.checkArgument((activityTasksCount <= this.outstandingReservationSlotsCount ? 1 : 0) != 0, (String)"Unexpectedly received %s eager activities though we only requested %s", (int)activityTasksCount, (int)this.outstandingReservationSlotsCount);
        this.releaseSlots(this.outstandingReservationSlotsCount - activityTasksCount);
        for (PollActivityTaskQueueResponse act : serverResponse.getActivityTasksList()) {
            this.eagerActivityDispatcher.dispatchActivity(act);
        }
        this.outstandingReservationSlotsCount = 0;
    }

    @Override
    public void close() {
        if (this.outstandingReservationSlotsCount > 0) {
            this.releaseSlots(this.outstandingReservationSlotsCount);
        }
    }

    private void releaseSlots(int slotsToRelease) {
        if (slotsToRelease > this.outstandingReservationSlotsCount) {
            throw new IllegalStateException("Trying to release more activity slots than outstanding reservations");
        }
        this.eagerActivityDispatcher.releaseActivitySlotReservations(slotsToRelease);
        this.outstandingReservationSlotsCount -= slotsToRelease;
    }
}

