/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkerLifecycleState;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class NoopWorker
implements SuspendableWorker {
    private final AtomicBoolean shutdown = new AtomicBoolean();

    NoopWorker() {
    }

    @Override
    public boolean start() {
        throw new IllegalStateException("Non startable");
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        this.shutdown.set(true);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
    }

    @Override
    public void suspendPolling() {
    }

    @Override
    public void resumePolling() {
    }

    @Override
    public boolean isSuspended() {
        return true;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown.get();
    }

    @Override
    public WorkerLifecycleState getLifecycleState() {
        return WorkerLifecycleState.NOT_STARTED;
    }
}

