/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public final class WorkflowRunLockManager {
    private final Map<String, RefCountedLock> runIdLock = new ConcurrentHashMap<String, RefCountedLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(String runId, long timeout, TimeUnit unit) throws InterruptedException {
        RefCountedLock runLock = this.obtainLock(runId);
        boolean obtained = false;
        try {
            boolean bl = obtained = runLock.lock.tryLock(timeout, unit);
            return bl;
        }
        finally {
            if (!obtained) {
                this.derefAndUnlock(runId, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(String runId) {
        RefCountedLock runLock = this.obtainLock(runId);
        boolean obtained = false;
        try {
            boolean bl = obtained = runLock.lock.tryLock();
            return bl;
        }
        finally {
            if (!obtained) {
                this.derefAndUnlock(runId, false);
            }
        }
    }

    public void unlock(String runId) {
        this.derefAndUnlock(runId, true);
    }

    private RefCountedLock obtainLock(String runId) {
        return this.runIdLock.compute(runId, (id, lock) -> {
            if (lock == null) {
                lock = new RefCountedLock();
            }
            ++lock.refCount;
            return lock;
        });
    }

    private void derefAndUnlock(String runId, boolean unlock) {
        this.runIdLock.compute(runId, (id, runLock) -> {
            Preconditions.checkState((runLock != null ? 1 : 0) != 0, (String)"Thread '%s' doesn't have an acquired lock for runId '%s'", (Object)Thread.currentThread().getName(), (Object)runId);
            if (unlock) {
                runLock.lock.unlock();
            }
            return --runLock.refCount == 0 ? null : runLock;
        });
    }

    @VisibleForTesting
    int totalLocks() {
        return this.runIdLock.size();
    }

    private static class RefCountedLock {
        final ReentrantLock lock = new ReentrantLock();
        int refCount = 0;

        private RefCountedLock() {
        }
    }
}

