/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.base.Preconditions;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.internal.worker.WorkflowTask;
import java.io.Closeable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class WorkflowTaskDispatchHandle
implements Closeable {
    private final AtomicBoolean completed = new AtomicBoolean();
    private final Function<WorkflowTask, Boolean> dispatchCallback;
    private final Semaphore executorSlotsSemaphore;

    public WorkflowTaskDispatchHandle(DispatchCallback dispatchCallback, Semaphore executorSlotsSemaphore) {
        this.dispatchCallback = dispatchCallback;
        this.executorSlotsSemaphore = executorSlotsSemaphore;
    }

    public boolean dispatch(@Nonnull PollWorkflowTaskQueueResponse workflowTask) {
        Preconditions.checkNotNull((Object)workflowTask, (Object)"workflowTask");
        if (this.completed.compareAndSet(false, true)) {
            return this.dispatchCallback.apply(new WorkflowTask(workflowTask, this.executorSlotsSemaphore::release));
        }
        return false;
    }

    @Override
    public void close() {
        if (this.completed.compareAndSet(false, true)) {
            this.executorSlotsSemaphore.release();
        }
    }

    @FunctionalInterface
    public static interface DispatchCallback
    extends Function<WorkflowTask, Boolean> {
        @Override
        public Boolean apply(WorkflowTask var1) throws IllegalArgumentException;
    }
}

