/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.HealthStatusManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GRPCServerHelper {
    public static void registerServicesAndHealthChecks(Collection<BindableService> services, ServerBuilder<?> toServerBuilder) {
        GRPCServerHelper.registerServicesAndHealthChecks(services, toServerBuilder, Collections.emptyList());
    }

    public static void registerServicesAndHealthChecks(Collection<BindableService> services, ServerBuilder<?> toServerBuilder, List<ServerInterceptor> interceptors) {
        HealthStatusManager healthStatusManager = new HealthStatusManager();
        for (BindableService service : services) {
            toServerBuilder.addService(ServerInterceptors.intercept((ServerServiceDefinition)service.bindService(), interceptors));
            healthStatusManager.setStatus(service.bindService().getServiceDescriptor().getName(), HealthCheckResponse.ServingStatus.SERVING);
        }
        toServerBuilder.addService(ServerInterceptors.intercept((BindableService)healthStatusManager.getHealthService(), interceptors));
    }
}

