/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import io.temporal.internal.common.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusUtils {
    private static final Logger log = LoggerFactory.getLogger(StatusUtils.class);

    public static boolean hasFailure(StatusRuntimeException exception, Class<? extends Message> failureType) {
        Preconditions.checkNotNull((Object)((Object)exception), (Object)"exception cannot be null");
        Status status = StatusProto.fromThrowable((Throwable)exception);
        if (status.getDetailsCount() == 0) {
            return false;
        }
        Any details = status.getDetails(0);
        return details.is(failureType);
    }

    public static <T extends Message> T getFailure(StatusRuntimeException exception, Class<T> failureType) {
        Preconditions.checkNotNull((Object)((Object)exception), (Object)"exception cannot be null");
        Status status = StatusProto.fromThrowable((Throwable)exception);
        if (status.getDetailsCount() == 0) {
            return null;
        }
        Any details = status.getDetails(0);
        try {
            if (details.is(failureType)) {
                return (T)details.unpack(failureType);
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Failure to construct gRPC error of type " + failureType + " from " + details, e);
        }
        return null;
    }

    public static <T extends Message> StatusRuntimeException newException(io.grpc.Status status, T details, Descriptors.Descriptor detailsDescriptor) {
        Preconditions.checkNotNull((Object)status, (Object)"status cannot be null");
        Status protoStatus = Status.newBuilder().setCode(status.getCode().value()).setMessage(status.getDescription()).addDetails(ProtoUtils.packAny(details, detailsDescriptor)).build();
        return StatusProto.toStatusRuntimeException((Status)protoStatus);
    }
}

