/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.logging.AsyncHandler;
import org.wildfly.swarm.config.logging.AsyncHandlerConsumer;
import org.wildfly.swarm.config.logging.AsyncHandlerSupplier;
import org.wildfly.swarm.config.logging.ConsoleHandler;
import org.wildfly.swarm.config.logging.ConsoleHandlerConsumer;
import org.wildfly.swarm.config.logging.ConsoleHandlerSupplier;
import org.wildfly.swarm.config.logging.CustomFormatter;
import org.wildfly.swarm.config.logging.CustomFormatterConsumer;
import org.wildfly.swarm.config.logging.CustomFormatterSupplier;
import org.wildfly.swarm.config.logging.CustomHandler;
import org.wildfly.swarm.config.logging.CustomHandlerConsumer;
import org.wildfly.swarm.config.logging.CustomHandlerSupplier;
import org.wildfly.swarm.config.logging.FileHandler;
import org.wildfly.swarm.config.logging.FileHandlerConsumer;
import org.wildfly.swarm.config.logging.FileHandlerSupplier;
import org.wildfly.swarm.config.logging.JsonFormatter;
import org.wildfly.swarm.config.logging.JsonFormatterConsumer;
import org.wildfly.swarm.config.logging.JsonFormatterSupplier;
import org.wildfly.swarm.config.logging.LogFile;
import org.wildfly.swarm.config.logging.LogFileConsumer;
import org.wildfly.swarm.config.logging.LogFileSupplier;
import org.wildfly.swarm.config.logging.Logger;
import org.wildfly.swarm.config.logging.LoggerConsumer;
import org.wildfly.swarm.config.logging.LoggerSupplier;
import org.wildfly.swarm.config.logging.LoggingProfile;
import org.wildfly.swarm.config.logging.LoggingProfileConsumer;
import org.wildfly.swarm.config.logging.LoggingProfileSupplier;
import org.wildfly.swarm.config.logging.PatternFormatter;
import org.wildfly.swarm.config.logging.PatternFormatterConsumer;
import org.wildfly.swarm.config.logging.PatternFormatterSupplier;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandlerConsumer;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandlerSupplier;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandlerConsumer;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandlerSupplier;
import org.wildfly.swarm.config.logging.RootLogger;
import org.wildfly.swarm.config.logging.RootLoggerConsumer;
import org.wildfly.swarm.config.logging.RootLoggerSupplier;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandlerConsumer;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandlerSupplier;
import org.wildfly.swarm.config.logging.SocketHandler;
import org.wildfly.swarm.config.logging.SocketHandlerConsumer;
import org.wildfly.swarm.config.logging.SocketHandlerSupplier;
import org.wildfly.swarm.config.logging.SyslogHandler;
import org.wildfly.swarm.config.logging.SyslogHandlerConsumer;
import org.wildfly.swarm.config.logging.SyslogHandlerSupplier;
import org.wildfly.swarm.config.logging.XmlFormatter;
import org.wildfly.swarm.config.logging.XmlFormatterConsumer;
import org.wildfly.swarm.config.logging.XmlFormatterSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=logging")
@ResourceType(value="subsystem")
@Implicit
public class Logging<T extends Logging<T>>
implements Keyed {
    private String key = "logging";
    private PropertyChangeSupport pcs;
    private LoggingResources subresources = new LoggingResources();
    @AttributeDocumentation(value="Indicates whether or not logging API dependencies should be added to deployments during the deployment process. A value of true will add the dependencies to the deployment. A value of false will skip the deployment from being processed for logging API dependencies.")
    private Boolean addLoggingApiDependencies;
    @AttributeDocumentation(value="Indicates whether or not deployments should use a logging configuration file found in the deployment to configure the log manager. If set to true and a logging configuration file was found in the deployments META-INF or WEB-INF/classes directory, then a log manager will be configured with those settings. If set false the servers logging configuration will be used regardless of any logging configuration files supplied in the deployment.")
    private Boolean useDeploymentLoggingConfig;

    public Logging() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public LoggingResources subresources() {
        return this.subresources;
    }

    public T periodicRotatingFileHandlers(List<PeriodicRotatingFileHandler> value) {
        this.subresources.periodicRotatingFileHandlers = value;
        return (T)this;
    }

    public T periodicRotatingFileHandler(PeriodicRotatingFileHandler value) {
        this.subresources.periodicRotatingFileHandlers.add(value);
        return (T)this;
    }

    public T periodicRotatingFileHandler(String childKey, PeriodicRotatingFileHandlerConsumer consumer) {
        PeriodicRotatingFileHandler child = new PeriodicRotatingFileHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.periodicRotatingFileHandler(child);
        return (T)this;
    }

    public T periodicRotatingFileHandler(String childKey) {
        this.periodicRotatingFileHandler(childKey, null);
        return (T)this;
    }

    public T periodicRotatingFileHandler(PeriodicRotatingFileHandlerSupplier supplier) {
        this.periodicRotatingFileHandler(supplier.get());
        return (T)this;
    }

    public T jsonFormatters(List<JsonFormatter> value) {
        this.subresources.jsonFormatters = value;
        return (T)this;
    }

    public T jsonFormatter(JsonFormatter value) {
        this.subresources.jsonFormatters.add(value);
        return (T)this;
    }

    public T jsonFormatter(String childKey, JsonFormatterConsumer consumer) {
        JsonFormatter child = new JsonFormatter(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jsonFormatter(child);
        return (T)this;
    }

    public T jsonFormatter(String childKey) {
        this.jsonFormatter(childKey, null);
        return (T)this;
    }

    public T jsonFormatter(JsonFormatterSupplier supplier) {
        this.jsonFormatter(supplier.get());
        return (T)this;
    }

    public T socketHandlers(List<SocketHandler> value) {
        this.subresources.socketHandlers = value;
        return (T)this;
    }

    public T socketHandler(SocketHandler value) {
        this.subresources.socketHandlers.add(value);
        return (T)this;
    }

    public T socketHandler(String childKey, SocketHandlerConsumer consumer) {
        SocketHandler child = new SocketHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.socketHandler(child);
        return (T)this;
    }

    public T socketHandler(String childKey) {
        this.socketHandler(childKey, null);
        return (T)this;
    }

    public T socketHandler(SocketHandlerSupplier supplier) {
        this.socketHandler(supplier.get());
        return (T)this;
    }

    public T loggers(List<Logger> value) {
        this.subresources.loggers = value;
        return (T)this;
    }

    public T logger(Logger value) {
        this.subresources.loggers.add(value);
        return (T)this;
    }

    public T logger(String childKey, LoggerConsumer consumer) {
        Logger child = new Logger(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.logger(child);
        return (T)this;
    }

    public T logger(String childKey) {
        this.logger(childKey, null);
        return (T)this;
    }

    public T logger(LoggerSupplier supplier) {
        this.logger(supplier.get());
        return (T)this;
    }

    public T asyncHandlers(List<AsyncHandler> value) {
        this.subresources.asyncHandlers = value;
        return (T)this;
    }

    public T asyncHandler(AsyncHandler value) {
        this.subresources.asyncHandlers.add(value);
        return (T)this;
    }

    public T asyncHandler(String childKey, AsyncHandlerConsumer consumer) {
        AsyncHandler child = new AsyncHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.asyncHandler(child);
        return (T)this;
    }

    public T asyncHandler(String childKey) {
        this.asyncHandler(childKey, null);
        return (T)this;
    }

    public T asyncHandler(AsyncHandlerSupplier supplier) {
        this.asyncHandler(supplier.get());
        return (T)this;
    }

    public T fileHandlers(List<FileHandler> value) {
        this.subresources.fileHandlers = value;
        return (T)this;
    }

    public T fileHandler(FileHandler value) {
        this.subresources.fileHandlers.add(value);
        return (T)this;
    }

    public T fileHandler(String childKey, FileHandlerConsumer consumer) {
        FileHandler child = new FileHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.fileHandler(child);
        return (T)this;
    }

    public T fileHandler(String childKey) {
        this.fileHandler(childKey, null);
        return (T)this;
    }

    public T fileHandler(FileHandlerSupplier supplier) {
        this.fileHandler(supplier.get());
        return (T)this;
    }

    public T sizeRotatingFileHandlers(List<SizeRotatingFileHandler> value) {
        this.subresources.sizeRotatingFileHandlers = value;
        return (T)this;
    }

    public T sizeRotatingFileHandler(SizeRotatingFileHandler value) {
        this.subresources.sizeRotatingFileHandlers.add(value);
        return (T)this;
    }

    public T sizeRotatingFileHandler(String childKey, SizeRotatingFileHandlerConsumer consumer) {
        SizeRotatingFileHandler child = new SizeRotatingFileHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.sizeRotatingFileHandler(child);
        return (T)this;
    }

    public T sizeRotatingFileHandler(String childKey) {
        this.sizeRotatingFileHandler(childKey, null);
        return (T)this;
    }

    public T sizeRotatingFileHandler(SizeRotatingFileHandlerSupplier supplier) {
        this.sizeRotatingFileHandler(supplier.get());
        return (T)this;
    }

    public T syslogHandlers(List<SyslogHandler> value) {
        this.subresources.syslogHandlers = value;
        return (T)this;
    }

    public T syslogHandler(SyslogHandler value) {
        this.subresources.syslogHandlers.add(value);
        return (T)this;
    }

    public T syslogHandler(String childKey, SyslogHandlerConsumer consumer) {
        SyslogHandler child = new SyslogHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.syslogHandler(child);
        return (T)this;
    }

    public T syslogHandler(String childKey) {
        this.syslogHandler(childKey, null);
        return (T)this;
    }

    public T syslogHandler(SyslogHandlerSupplier supplier) {
        this.syslogHandler(supplier.get());
        return (T)this;
    }

    public T loggingProfiles(List<LoggingProfile> value) {
        this.subresources.loggingProfiles = value;
        return (T)this;
    }

    public T loggingProfile(LoggingProfile value) {
        this.subresources.loggingProfiles.add(value);
        return (T)this;
    }

    public T loggingProfile(String childKey, LoggingProfileConsumer consumer) {
        LoggingProfile child = new LoggingProfile(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.loggingProfile(child);
        return (T)this;
    }

    public T loggingProfile(String childKey) {
        this.loggingProfile(childKey, null);
        return (T)this;
    }

    public T loggingProfile(LoggingProfileSupplier supplier) {
        this.loggingProfile(supplier.get());
        return (T)this;
    }

    public T customFormatters(List<CustomFormatter> value) {
        this.subresources.customFormatters = value;
        return (T)this;
    }

    public T customFormatter(CustomFormatter value) {
        this.subresources.customFormatters.add(value);
        return (T)this;
    }

    public T customFormatter(String childKey, CustomFormatterConsumer consumer) {
        CustomFormatter child = new CustomFormatter(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.customFormatter(child);
        return (T)this;
    }

    public T customFormatter(String childKey) {
        this.customFormatter(childKey, null);
        return (T)this;
    }

    public T customFormatter(CustomFormatterSupplier supplier) {
        this.customFormatter(supplier.get());
        return (T)this;
    }

    public T periodicSizeRotatingFileHandlers(List<PeriodicSizeRotatingFileHandler> value) {
        this.subresources.periodicSizeRotatingFileHandlers = value;
        return (T)this;
    }

    public T periodicSizeRotatingFileHandler(PeriodicSizeRotatingFileHandler value) {
        this.subresources.periodicSizeRotatingFileHandlers.add(value);
        return (T)this;
    }

    public T periodicSizeRotatingFileHandler(String childKey, PeriodicSizeRotatingFileHandlerConsumer consumer) {
        PeriodicSizeRotatingFileHandler child = new PeriodicSizeRotatingFileHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.periodicSizeRotatingFileHandler(child);
        return (T)this;
    }

    public T periodicSizeRotatingFileHandler(String childKey) {
        this.periodicSizeRotatingFileHandler(childKey, null);
        return (T)this;
    }

    public T periodicSizeRotatingFileHandler(PeriodicSizeRotatingFileHandlerSupplier supplier) {
        this.periodicSizeRotatingFileHandler(supplier.get());
        return (T)this;
    }

    public T consoleHandlers(List<ConsoleHandler> value) {
        this.subresources.consoleHandlers = value;
        return (T)this;
    }

    public T consoleHandler(ConsoleHandler value) {
        this.subresources.consoleHandlers.add(value);
        return (T)this;
    }

    public T consoleHandler(String childKey, ConsoleHandlerConsumer consumer) {
        ConsoleHandler child = new ConsoleHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.consoleHandler(child);
        return (T)this;
    }

    public T consoleHandler(String childKey) {
        this.consoleHandler(childKey, null);
        return (T)this;
    }

    public T consoleHandler(ConsoleHandlerSupplier supplier) {
        this.consoleHandler(supplier.get());
        return (T)this;
    }

    public T xmlFormatters(List<XmlFormatter> value) {
        this.subresources.xmlFormatters = value;
        return (T)this;
    }

    public T xmlFormatter(XmlFormatter value) {
        this.subresources.xmlFormatters.add(value);
        return (T)this;
    }

    public T xmlFormatter(String childKey, XmlFormatterConsumer consumer) {
        XmlFormatter child = new XmlFormatter(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.xmlFormatter(child);
        return (T)this;
    }

    public T xmlFormatter(String childKey) {
        this.xmlFormatter(childKey, null);
        return (T)this;
    }

    public T xmlFormatter(XmlFormatterSupplier supplier) {
        this.xmlFormatter(supplier.get());
        return (T)this;
    }

    public T logFiles(List<LogFile> value) {
        this.subresources.logFiles = value;
        return (T)this;
    }

    public T logFile(LogFile value) {
        this.subresources.logFiles.add(value);
        return (T)this;
    }

    public T logFile(String childKey, LogFileConsumer consumer) {
        LogFile child = new LogFile(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.logFile(child);
        return (T)this;
    }

    public T logFile(String childKey) {
        this.logFile(childKey, null);
        return (T)this;
    }

    public T logFile(LogFileSupplier supplier) {
        this.logFile(supplier.get());
        return (T)this;
    }

    public T patternFormatters(List<PatternFormatter> value) {
        this.subresources.patternFormatters = value;
        return (T)this;
    }

    public T patternFormatter(PatternFormatter value) {
        this.subresources.patternFormatters.add(value);
        return (T)this;
    }

    public T patternFormatter(String childKey, PatternFormatterConsumer consumer) {
        PatternFormatter child = new PatternFormatter(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.patternFormatter(child);
        return (T)this;
    }

    public T patternFormatter(String childKey) {
        this.patternFormatter(childKey, null);
        return (T)this;
    }

    public T patternFormatter(PatternFormatterSupplier supplier) {
        this.patternFormatter(supplier.get());
        return (T)this;
    }

    public T customHandlers(List<CustomHandler> value) {
        this.subresources.customHandlers = value;
        return (T)this;
    }

    public T customHandler(CustomHandler value) {
        this.subresources.customHandlers.add(value);
        return (T)this;
    }

    public T customHandler(String childKey, CustomHandlerConsumer consumer) {
        CustomHandler child = new CustomHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.customHandler(child);
        return (T)this;
    }

    public T customHandler(String childKey) {
        this.customHandler(childKey, null);
        return (T)this;
    }

    public T customHandler(CustomHandlerSupplier supplier) {
        this.customHandler(supplier.get());
        return (T)this;
    }

    public T rootLogger(RootLogger value) {
        this.subresources.rootLogger = value;
        return (T)this;
    }

    public T rootLogger(RootLoggerConsumer consumer) {
        RootLogger child = new RootLogger();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.rootLogger = child;
        return (T)this;
    }

    public T rootLogger() {
        RootLogger child = new RootLogger();
        this.subresources.rootLogger = child;
        return (T)this;
    }

    public T rootLogger(RootLoggerSupplier supplier) {
        this.subresources.rootLogger = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="add-logging-api-dependencies")
    public Boolean addLoggingApiDependencies() {
        return this.addLoggingApiDependencies;
    }

    public T addLoggingApiDependencies(Boolean value) {
        Boolean oldValue = this.addLoggingApiDependencies;
        this.addLoggingApiDependencies = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("addLoggingApiDependencies", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-deployment-logging-config")
    public Boolean useDeploymentLoggingConfig() {
        return this.useDeploymentLoggingConfig;
    }

    public T useDeploymentLoggingConfig(Boolean value) {
        Boolean oldValue = this.useDeploymentLoggingConfig;
        this.useDeploymentLoggingConfig = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useDeploymentLoggingConfig", oldValue, value);
        }
        return (T)this;
    }

    public static class LoggingResources {
        @ResourceDocumentation(value="Defines a handler which writes to a file, rotating the log after a time period derived from the given suffix string, which should be in a format understood by java.text.SimpleDateFormat.")
        @SubresourceInfo(value="periodicRotatingFileHandler")
        private List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers = new ArrayList<PeriodicRotatingFileHandler>();
        @ResourceDocumentation(value="A formatter that formats log messages in JSON.")
        @SubresourceInfo(value="jsonFormatter")
        private List<JsonFormatter> jsonFormatters = new ArrayList<JsonFormatter>();
        @ResourceDocumentation(value="Defines a handler which writes to a socket. Note that a socket-handler will queue messages during the boot process. These messages will be drained to the socket once the resource is fully configured. If the server is in admin-only state messages will be discarded.")
        @SubresourceInfo(value="socketHandler")
        private List<SocketHandler> socketHandlers = new ArrayList<SocketHandler>();
        @ResourceDocumentation(value="Defines a logger category.")
        @SubresourceInfo(value="logger")
        private List<Logger> loggers = new ArrayList<Logger>();
        @ResourceDocumentation(value="Defines a handler which writes to the sub-handlers in an asynchronous thread. Used for handlers which introduce a substantial amount of lag.")
        @SubresourceInfo(value="asyncHandler")
        private List<AsyncHandler> asyncHandlers = new ArrayList<AsyncHandler>();
        @ResourceDocumentation(value="Defines a handler which writes to a file.")
        @SubresourceInfo(value="fileHandler")
        private List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
        @ResourceDocumentation(value="Defines a handler which writes to a file, rotating the log after the size of the file grows beyond a certain point and keeping a fixed number of backups.")
        @SubresourceInfo(value="sizeRotatingFileHandler")
        private List<SizeRotatingFileHandler> sizeRotatingFileHandlers = new ArrayList<SizeRotatingFileHandler>();
        @ResourceDocumentation(value="Defines a syslog handler.")
        @SubresourceInfo(value="syslogHandler")
        private List<SyslogHandler> syslogHandlers = new ArrayList<SyslogHandler>();
        @ResourceDocumentation(value="The configuration of the logging subsystem.")
        @SubresourceInfo(value="loggingProfile")
        private List<LoggingProfile> loggingProfiles = new ArrayList<LoggingProfile>();
        @ResourceDocumentation(value="A custom formatter to be used with handlers. Note that most log records are formatted in the printf format. Formatters may require invocation of the org.jboss.logmanager.ExtLogRecord#getFormattedMessage() for the message to be properly formatted.")
        @SubresourceInfo(value="customFormatter")
        private List<CustomFormatter> customFormatters = new ArrayList<CustomFormatter>();
        @ResourceDocumentation(value="Defines a handler which writes to a file, rotating the log after a time period derived from the given suffix string or after the size of the file grows beyond a certain point and keeping a fixed number of backups. The suffix should be in a format understood by the java.text.SimpleDateFormat. Any backups rotated by the suffix will not be purged during a size rotation.")
        @SubresourceInfo(value="periodicSizeRotatingFileHandler")
        private List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers = new ArrayList<PeriodicSizeRotatingFileHandler>();
        @ResourceDocumentation(value="Defines a handler which writes to the console.")
        @SubresourceInfo(value="consoleHandler")
        private List<ConsoleHandler> consoleHandlers = new ArrayList<ConsoleHandler>();
        @ResourceDocumentation(value="A formatter that formats log messages in XML.")
        @SubresourceInfo(value="xmlFormatter")
        private List<XmlFormatter> xmlFormatters = new ArrayList<XmlFormatter>();
        @ResourceDocumentation(value="Log files that are available to be read.")
        @SubresourceInfo(value="logFile")
        private List<LogFile> logFiles = new ArrayList<LogFile>();
        @ResourceDocumentation(value="A pattern formatter to be used with handlers.")
        @SubresourceInfo(value="patternFormatter")
        private List<PatternFormatter> patternFormatters = new ArrayList<PatternFormatter>();
        @ResourceDocumentation(value="Defines a custom logging handler. The custom handler must extend java.util.logging.Handler.")
        @SubresourceInfo(value="customHandler")
        private List<CustomHandler> customHandlers = new ArrayList<CustomHandler>();
        @SingletonResource
        @ResourceDocumentation(value="Defines the root logger for this log context.")
        private RootLogger rootLogger;

        @Subresource
        public List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers() {
            return this.periodicRotatingFileHandlers;
        }

        public PeriodicRotatingFileHandler periodicRotatingFileHandler(String key) {
            return this.periodicRotatingFileHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<JsonFormatter> jsonFormatters() {
            return this.jsonFormatters;
        }

        public JsonFormatter jsonFormatter(String key) {
            return this.jsonFormatters.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<SocketHandler> socketHandlers() {
            return this.socketHandlers;
        }

        public SocketHandler socketHandler(String key) {
            return this.socketHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Logger> loggers() {
            return this.loggers;
        }

        public Logger logger(String key) {
            return this.loggers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<AsyncHandler> asyncHandlers() {
            return this.asyncHandlers;
        }

        public AsyncHandler asyncHandler(String key) {
            return this.asyncHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<FileHandler> fileHandlers() {
            return this.fileHandlers;
        }

        public FileHandler fileHandler(String key) {
            return this.fileHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<SizeRotatingFileHandler> sizeRotatingFileHandlers() {
            return this.sizeRotatingFileHandlers;
        }

        public SizeRotatingFileHandler sizeRotatingFileHandler(String key) {
            return this.sizeRotatingFileHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<SyslogHandler> syslogHandlers() {
            return this.syslogHandlers;
        }

        public SyslogHandler syslogHandler(String key) {
            return this.syslogHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<LoggingProfile> loggingProfiles() {
            return this.loggingProfiles;
        }

        public LoggingProfile loggingProfile(String key) {
            return this.loggingProfiles.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<CustomFormatter> customFormatters() {
            return this.customFormatters;
        }

        public CustomFormatter customFormatter(String key) {
            return this.customFormatters.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers() {
            return this.periodicSizeRotatingFileHandlers;
        }

        public PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler(String key) {
            return this.periodicSizeRotatingFileHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ConsoleHandler> consoleHandlers() {
            return this.consoleHandlers;
        }

        public ConsoleHandler consoleHandler(String key) {
            return this.consoleHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<XmlFormatter> xmlFormatters() {
            return this.xmlFormatters;
        }

        public XmlFormatter xmlFormatter(String key) {
            return this.xmlFormatters.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<LogFile> logFiles() {
            return this.logFiles;
        }

        public LogFile logFile(String key) {
            return this.logFiles.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<PatternFormatter> patternFormatters() {
            return this.patternFormatters;
        }

        public PatternFormatter patternFormatter(String key) {
            return this.patternFormatters.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<CustomHandler> customHandlers() {
            return this.customHandlers;
        }

        public CustomHandler customHandler(String key) {
            return this.customHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public RootLogger rootLogger() {
            return this.rootLogger;
        }
    }
}

