/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.remoting.Connector;
import org.wildfly.swarm.config.remoting.ConnectorConsumer;
import org.wildfly.swarm.config.remoting.ConnectorSupplier;
import org.wildfly.swarm.config.remoting.EndpointConfiguration;
import org.wildfly.swarm.config.remoting.EndpointConfigurationConsumer;
import org.wildfly.swarm.config.remoting.EndpointConfigurationSupplier;
import org.wildfly.swarm.config.remoting.HTTPConnector;
import org.wildfly.swarm.config.remoting.HTTPConnectorConsumer;
import org.wildfly.swarm.config.remoting.HTTPConnectorSupplier;
import org.wildfly.swarm.config.remoting.LocalOutboundConnection;
import org.wildfly.swarm.config.remoting.LocalOutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.LocalOutboundConnectionSupplier;
import org.wildfly.swarm.config.remoting.OutboundConnection;
import org.wildfly.swarm.config.remoting.OutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.OutboundConnectionSupplier;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnection;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnectionSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=remoting")
@ResourceType(value="subsystem")
@Implicit
public class Remoting<T extends Remoting<T>>
implements Keyed {
    private String key = "remoting";
    private PropertyChangeSupport pcs;
    private RemotingResources subresources = new RemotingResources();
    @AttributeDocumentation(value="The authentication realm to use if no authentication CallbackHandler is specified.")
    private String authRealm;
    @AttributeDocumentation(value="Specify the number of times a client is allowed to retry authentication before closing the connection.")
    private Integer authenticationRetries;
    @AttributeDocumentation(value="The SASL authorization ID.  Used as authentication user name to use if no authentication CallbackHandler is specifiedand the selected SASL mechanism demands a user name.")
    private String authorizeId;
    @AttributeDocumentation(value="The size of allocated buffer regions.")
    private Integer bufferRegionSize;
    @AttributeDocumentation(value="The interval to use for connection heartbeat, in milliseconds.  If the connection is idle in the outbound directionfor this amount of time, a ping message will be sent, which will trigger a corresponding reply message.")
    private Integer heartbeatInterval;
    @AttributeDocumentation(value="The maximum number of inbound channels to support for a connection.")
    private Integer maxInboundChannels;
    @AttributeDocumentation(value="The maximum inbound message size to be allowed.  Messages exceeding this size will cause an exception to be thrown on the reading side as well as the writing side.")
    private Long maxInboundMessageSize;
    @AttributeDocumentation(value="The maximum number of concurrent inbound messages on a channel.")
    private Integer maxInboundMessages;
    @AttributeDocumentation(value="The maximum number of outbound channels to support for a connection.")
    private Integer maxOutboundChannels;
    @AttributeDocumentation(value="The maximum outbound message size to send.  No messages larger than this well be transmitted; attempting to do so will cause an exception on the writing side.")
    private Long maxOutboundMessageSize;
    @AttributeDocumentation(value="The maximum number of concurrent outbound messages on a channel.")
    private Integer maxOutboundMessages;
    @AttributeDocumentation(value="The size of the largest buffer that this endpoint will accept over a connection.")
    private Integer receiveBufferSize;
    @AttributeDocumentation(value="The maximum window size of the receive direction for connection channels, in bytes.")
    private Integer receiveWindowSize;
    @AttributeDocumentation(value="Where a SaslServer or SaslClient are created by default the protocol specified it 'remoting', this can be used to override this.")
    private String saslProtocol;
    @AttributeDocumentation(value="The size of the largest buffer that this endpoint will transmit over a connection.")
    private Integer sendBufferSize;
    @AttributeDocumentation(value="The server side of the connection passes it's name to the client in the initial greeting, by default the name is automatically discovered from the local address of the connection or it can be overridden using this.")
    private String serverName;
    @AttributeDocumentation(value="The maximum window size of the transmit direction for connection channels, in bytes.")
    private Integer transmitWindowSize;
    @AttributeDocumentation(value="Worker to use")
    private String worker;
    @AttributeDocumentation(value="The number of read threads to create for the remoting worker.")
    private Integer workerReadThreads;
    @AttributeDocumentation(value="The number of core threads for the remoting worker task thread pool.")
    private Integer workerTaskCoreThreads;
    @AttributeDocumentation(value="The number of milliseconds to keep non-core remoting worker task threads alive.")
    private Integer workerTaskKeepalive;
    @AttributeDocumentation(value="The maximum number of remoting worker tasks to allow before rejecting.")
    private Integer workerTaskLimit;
    @AttributeDocumentation(value="The maximum number of threads for the remoting worker task thread pool.")
    private Integer workerTaskMaxThreads;
    @AttributeDocumentation(value="The number of write threads to create for the remoting worker.")
    private Integer workerWriteThreads;

    public Remoting() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public RemotingResources subresources() {
        return this.subresources;
    }

    public T httpConnectors(List<HTTPConnector> value) {
        this.subresources.httpConnectors = value;
        return (T)this;
    }

    public T httpConnector(HTTPConnector value) {
        this.subresources.httpConnectors.add(value);
        return (T)this;
    }

    public T httpConnector(String childKey, HTTPConnectorConsumer consumer) {
        HTTPConnector child = new HTTPConnector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.httpConnector(child);
        return (T)this;
    }

    public T httpConnector(String childKey) {
        this.httpConnector(childKey, null);
        return (T)this;
    }

    public T httpConnector(HTTPConnectorSupplier supplier) {
        this.httpConnector(supplier.get());
        return (T)this;
    }

    public T connectors(List<Connector> value) {
        this.subresources.connectors = value;
        return (T)this;
    }

    public T connector(Connector value) {
        this.subresources.connectors.add(value);
        return (T)this;
    }

    public T connector(String childKey, ConnectorConsumer consumer) {
        Connector child = new Connector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connector(child);
        return (T)this;
    }

    public T connector(String childKey) {
        this.connector(childKey, null);
        return (T)this;
    }

    public T connector(ConnectorSupplier supplier) {
        this.connector(supplier.get());
        return (T)this;
    }

    public T outboundConnections(List<OutboundConnection> value) {
        this.subresources.outboundConnections = value;
        return (T)this;
    }

    public T outboundConnection(OutboundConnection value) {
        this.subresources.outboundConnections.add(value);
        return (T)this;
    }

    public T outboundConnection(String childKey, OutboundConnectionConsumer consumer) {
        OutboundConnection child = new OutboundConnection(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.outboundConnection(child);
        return (T)this;
    }

    public T outboundConnection(String childKey) {
        this.outboundConnection(childKey, null);
        return (T)this;
    }

    public T outboundConnection(OutboundConnectionSupplier supplier) {
        this.outboundConnection(supplier.get());
        return (T)this;
    }

    public T localOutboundConnections(List<LocalOutboundConnection> value) {
        this.subresources.localOutboundConnections = value;
        return (T)this;
    }

    public T localOutboundConnection(LocalOutboundConnection value) {
        this.subresources.localOutboundConnections.add(value);
        return (T)this;
    }

    public T localOutboundConnection(String childKey, LocalOutboundConnectionConsumer consumer) {
        LocalOutboundConnection child = new LocalOutboundConnection(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.localOutboundConnection(child);
        return (T)this;
    }

    public T localOutboundConnection(String childKey) {
        this.localOutboundConnection(childKey, null);
        return (T)this;
    }

    public T localOutboundConnection(LocalOutboundConnectionSupplier supplier) {
        this.localOutboundConnection(supplier.get());
        return (T)this;
    }

    public T remoteOutboundConnections(List<RemoteOutboundConnection> value) {
        this.subresources.remoteOutboundConnections = value;
        return (T)this;
    }

    public T remoteOutboundConnection(RemoteOutboundConnection value) {
        this.subresources.remoteOutboundConnections.add(value);
        return (T)this;
    }

    public T remoteOutboundConnection(String childKey, RemoteOutboundConnectionConsumer consumer) {
        RemoteOutboundConnection child = new RemoteOutboundConnection(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remoteOutboundConnection(child);
        return (T)this;
    }

    public T remoteOutboundConnection(String childKey) {
        this.remoteOutboundConnection(childKey, null);
        return (T)this;
    }

    public T remoteOutboundConnection(RemoteOutboundConnectionSupplier supplier) {
        this.remoteOutboundConnection(supplier.get());
        return (T)this;
    }

    public T endpointConfiguration(EndpointConfiguration value) {
        this.subresources.endpointConfiguration = value;
        return (T)this;
    }

    public T endpointConfiguration(EndpointConfigurationConsumer consumer) {
        EndpointConfiguration child = new EndpointConfiguration();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.endpointConfiguration = child;
        return (T)this;
    }

    public T endpointConfiguration() {
        EndpointConfiguration child = new EndpointConfiguration();
        this.subresources.endpointConfiguration = child;
        return (T)this;
    }

    public T endpointConfiguration(EndpointConfigurationSupplier supplier) {
        this.subresources.endpointConfiguration = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auth-realm")
    public String authRealm() {
        return this.authRealm;
    }

    public T authRealm(String value) {
        String oldValue = this.authRealm;
        this.authRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-retries")
    public Integer authenticationRetries() {
        return this.authenticationRetries;
    }

    public T authenticationRetries(Integer value) {
        Integer oldValue = this.authenticationRetries;
        this.authenticationRetries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationRetries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authorize-id")
    public String authorizeId() {
        return this.authorizeId;
    }

    public T authorizeId(String value) {
        String oldValue = this.authorizeId;
        this.authorizeId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authorizeId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-region-size")
    public Integer bufferRegionSize() {
        return this.bufferRegionSize;
    }

    public T bufferRegionSize(Integer value) {
        Integer oldValue = this.bufferRegionSize;
        this.bufferRegionSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferRegionSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="heartbeat-interval")
    public Integer heartbeatInterval() {
        return this.heartbeatInterval;
    }

    public T heartbeatInterval(Integer value) {
        Integer oldValue = this.heartbeatInterval;
        this.heartbeatInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("heartbeatInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-inbound-channels")
    public Integer maxInboundChannels() {
        return this.maxInboundChannels;
    }

    public T maxInboundChannels(Integer value) {
        Integer oldValue = this.maxInboundChannels;
        this.maxInboundChannels = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxInboundChannels", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-inbound-message-size")
    public Long maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public T maxInboundMessageSize(Long value) {
        Long oldValue = this.maxInboundMessageSize;
        this.maxInboundMessageSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxInboundMessageSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-inbound-messages")
    public Integer maxInboundMessages() {
        return this.maxInboundMessages;
    }

    public T maxInboundMessages(Integer value) {
        Integer oldValue = this.maxInboundMessages;
        this.maxInboundMessages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxInboundMessages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-outbound-channels")
    public Integer maxOutboundChannels() {
        return this.maxOutboundChannels;
    }

    public T maxOutboundChannels(Integer value) {
        Integer oldValue = this.maxOutboundChannels;
        this.maxOutboundChannels = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxOutboundChannels", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-outbound-message-size")
    public Long maxOutboundMessageSize() {
        return this.maxOutboundMessageSize;
    }

    public T maxOutboundMessageSize(Long value) {
        Long oldValue = this.maxOutboundMessageSize;
        this.maxOutboundMessageSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxOutboundMessageSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-outbound-messages")
    public Integer maxOutboundMessages() {
        return this.maxOutboundMessages;
    }

    public T maxOutboundMessages(Integer value) {
        Integer oldValue = this.maxOutboundMessages;
        this.maxOutboundMessages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxOutboundMessages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="receive-buffer-size")
    public Integer receiveBufferSize() {
        return this.receiveBufferSize;
    }

    public T receiveBufferSize(Integer value) {
        Integer oldValue = this.receiveBufferSize;
        this.receiveBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("receiveBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="receive-window-size")
    public Integer receiveWindowSize() {
        return this.receiveWindowSize;
    }

    public T receiveWindowSize(Integer value) {
        Integer oldValue = this.receiveWindowSize;
        this.receiveWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("receiveWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-protocol")
    public String saslProtocol() {
        return this.saslProtocol;
    }

    public T saslProtocol(String value) {
        String oldValue = this.saslProtocol;
        this.saslProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="send-buffer-size")
    public Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    public T sendBufferSize(Integer value) {
        Integer oldValue = this.sendBufferSize;
        this.sendBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sendBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-name")
    public String serverName() {
        return this.serverName;
    }

    public T serverName(String value) {
        String oldValue = this.serverName;
        this.serverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transmit-window-size")
    public Integer transmitWindowSize() {
        return this.transmitWindowSize;
    }

    public T transmitWindowSize(Integer value) {
        Integer oldValue = this.transmitWindowSize;
        this.transmitWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transmitWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker")
    public String worker() {
        return this.worker;
    }

    public T worker(String value) {
        String oldValue = this.worker;
        this.worker = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("worker", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker-read-threads")
    public Integer workerReadThreads() {
        return this.workerReadThreads;
    }

    public T workerReadThreads(Integer value) {
        Integer oldValue = this.workerReadThreads;
        this.workerReadThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workerReadThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker-task-core-threads")
    public Integer workerTaskCoreThreads() {
        return this.workerTaskCoreThreads;
    }

    public T workerTaskCoreThreads(Integer value) {
        Integer oldValue = this.workerTaskCoreThreads;
        this.workerTaskCoreThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workerTaskCoreThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker-task-keepalive")
    public Integer workerTaskKeepalive() {
        return this.workerTaskKeepalive;
    }

    public T workerTaskKeepalive(Integer value) {
        Integer oldValue = this.workerTaskKeepalive;
        this.workerTaskKeepalive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workerTaskKeepalive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker-task-limit")
    public Integer workerTaskLimit() {
        return this.workerTaskLimit;
    }

    public T workerTaskLimit(Integer value) {
        Integer oldValue = this.workerTaskLimit;
        this.workerTaskLimit = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workerTaskLimit", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker-task-max-threads")
    public Integer workerTaskMaxThreads() {
        return this.workerTaskMaxThreads;
    }

    public T workerTaskMaxThreads(Integer value) {
        Integer oldValue = this.workerTaskMaxThreads;
        this.workerTaskMaxThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workerTaskMaxThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker-write-threads")
    public Integer workerWriteThreads() {
        return this.workerWriteThreads;
    }

    public T workerWriteThreads(Integer value) {
        Integer oldValue = this.workerWriteThreads;
        this.workerWriteThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workerWriteThreads", oldValue, value);
        }
        return (T)this;
    }

    public static class RemotingResources {
        @ResourceDocumentation(value="The configuration of a HTTP Upgrade based Remoting connector.")
        @SubresourceInfo(value="httpConnector")
        private List<HTTPConnector> httpConnectors = new ArrayList<HTTPConnector>();
        @ResourceDocumentation(value="The configuration of a Remoting connector.")
        @SubresourceInfo(value="connector")
        private List<Connector> connectors = new ArrayList<Connector>();
        @ResourceDocumentation(value="Remoting outbound connection.")
        @SubresourceInfo(value="outboundConnection")
        private List<OutboundConnection> outboundConnections = new ArrayList<OutboundConnection>();
        @ResourceDocumentation(value="Remoting outbound connection with an implicit local:// URI scheme.")
        @SubresourceInfo(value="localOutboundConnection")
        private List<LocalOutboundConnection> localOutboundConnections = new ArrayList<LocalOutboundConnection>();
        @ResourceDocumentation(value="Remoting outbound connection.")
        @SubresourceInfo(value="remoteOutboundConnection")
        private List<RemoteOutboundConnection> remoteOutboundConnections = new ArrayList<RemoteOutboundConnection>();
        @SingletonResource
        @ResourceDocumentation(value="Endpoint configuration")
        private EndpointConfiguration endpointConfiguration;

        @Subresource
        public List<HTTPConnector> httpConnectors() {
            return this.httpConnectors;
        }

        public HTTPConnector httpConnector(String key) {
            return this.httpConnectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Connector> connectors() {
            return this.connectors;
        }

        public Connector connector(String key) {
            return this.connectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<OutboundConnection> outboundConnections() {
            return this.outboundConnections;
        }

        public OutboundConnection outboundConnection(String key) {
            return this.outboundConnections.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<LocalOutboundConnection> localOutboundConnections() {
            return this.localOutboundConnections;
        }

        public LocalOutboundConnection localOutboundConnection(String key) {
            return this.localOutboundConnections.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RemoteOutboundConnection> remoteOutboundConnections() {
            return this.remoteOutboundConnections;
        }

        public RemoteOutboundConnection remoteOutboundConnection(String key) {
            return this.remoteOutboundConnections.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public EndpointConfiguration endpointConfiguration() {
            return this.endpointConfiguration;
        }
    }
}

