/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=weld")
@ResourceType(value="subsystem")
@Implicit
public class Weld<T extends Weld<T>>
implements Keyed {
    private String key = "weld";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="Weld comes with a special mode for application development. When the development mode is enabled, certain built-in tools, which facilitate the development of CDI applications, are available. Setting this attribute to true activates the development mode.")
    private Boolean developmentMode;
    @AttributeDocumentation(value="If true then the non-portable mode is enabled. The non-portable mode is suggested by the specification to overcome problems with legacy applications that do not use CDI SPI properly and may be rejected by more strict validation in CDI 1.1.")
    private Boolean nonPortableMode;
    @AttributeDocumentation(value="If true then implicit bean archives without bean descriptor file (beans.xml) are ignored by Weld")
    private Boolean requireBeanDescriptor;
    @AttributeDocumentation(value="The number of threads to be used by the Weld thread pool. The pool is shared across all CDI-enabled deployments and used primarily for parallel Weld bootstrap.")
    private Integer threadPoolSize;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="development-mode")
    public Boolean developmentMode() {
        return this.developmentMode;
    }

    public T developmentMode(Boolean value) {
        Boolean oldValue = this.developmentMode;
        this.developmentMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("developmentMode", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="non-portable-mode")
    public Boolean nonPortableMode() {
        return this.nonPortableMode;
    }

    public T nonPortableMode(Boolean value) {
        Boolean oldValue = this.nonPortableMode;
        this.nonPortableMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nonPortableMode", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="require-bean-descriptor")
    public Boolean requireBeanDescriptor() {
        return this.requireBeanDescriptor;
    }

    public T requireBeanDescriptor(Boolean value) {
        Boolean oldValue = this.requireBeanDescriptor;
        this.requireBeanDescriptor = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requireBeanDescriptor", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-pool-size")
    public Integer threadPoolSize() {
        return this.threadPoolSize;
    }

    public T threadPoolSize(Integer value) {
        Integer oldValue = this.threadPoolSize;
        this.threadPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadPoolSize", oldValue, value);
        }
        return (T)this;
    }
}

