/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ee;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ee/managed-thread-factory=*")
@ResourceType(value="managed-thread-factory")
public class ManagedThreadFactory<T extends ManagedThreadFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the context service to be used by the managed thread factory")
    private String contextService;
    @AttributeDocumentation(value="The JNDI Name to lookup the managed thread factory.")
    private String jndiName;
    @AttributeDocumentation(value="The priority applied to threads created by the factory")
    private Integer priority;

    public ManagedThreadFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="context-service")
    public String contextService() {
        return this.contextService;
    }

    public T contextService(String value) {
        String oldValue = this.contextService;
        this.contextService = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("contextService", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="priority")
    public Integer priority() {
        return this.priority;
    }

    public T priority(Integer value) {
        Integer oldValue = this.priority;
        this.priority = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("priority", oldValue, value);
        }
        return (T)this;
    }
}

