/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ejb3/service=async")
@ResourceType(value="service")
@Implicit
public class AsyncService<T extends AsyncService<T>>
implements Keyed {
    private String key = "async";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The name of the thread pool which handles asynchronous invocations")
    private String threadPoolName;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="thread-pool-name")
    public String threadPoolName() {
        return this.threadPoolName;
    }

    public T threadPoolName(String value) {
        String oldValue = this.threadPoolName;
        this.threadPoolName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadPoolName", oldValue, value);
        }
        return (T)this;
    }
}

