/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/aggregate-http-server-mechanism-factory=*")
@ResourceType(value="aggregate-http-server-mechanism-factory")
public class AggregateHTTPServerMechanismFactory<T extends AggregateHTTPServerMechanismFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The HTTP mechanisms available from this factory instance.")
    private List<String> availableMechanisms;
    @AttributeDocumentation(value="The referenced http server factories to aggregate.")
    private List<String> httpServerMechanismFactories;

    public AggregateHTTPServerMechanismFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="available-mechanisms")
    public List<String> availableMechanisms() {
        return this.availableMechanisms;
    }

    public T availableMechanisms(List<String> value) {
        List<String> oldValue = this.availableMechanisms;
        this.availableMechanisms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
        }
        return (T)this;
    }

    public T availableMechanism(String value) {
        if (this.availableMechanisms == null) {
            this.availableMechanisms = new ArrayList<String>();
        }
        this.availableMechanisms.add(value);
        return (T)this;
    }

    public T availableMechanisms(String ... args) {
        this.availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http-server-mechanism-factories")
    public List<String> httpServerMechanismFactories() {
        return this.httpServerMechanismFactories;
    }

    public T httpServerMechanismFactories(List<String> value) {
        List<String> oldValue = this.httpServerMechanismFactories;
        this.httpServerMechanismFactories = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("httpServerMechanismFactories", oldValue, value);
        }
        return (T)this;
    }

    public T httpServerMechanismFactory(String value) {
        if (this.httpServerMechanismFactories == null) {
            this.httpServerMechanismFactories = new ArrayList<String>();
        }
        this.httpServerMechanismFactories.add(value);
        return (T)this;
    }

    public T httpServerMechanismFactories(String ... args) {
        this.httpServerMechanismFactories(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

