/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/aggregate-sasl-server-factory=*")
@ResourceType(value="aggregate-sasl-server-factory")
public class AggregateSASLServerFactory<T extends AggregateSASLServerFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The SASL mechanisms available from this factory after all filtering has been applied.")
    private List<String> availableMechanisms;
    @AttributeDocumentation(value="The referenced sasl server factories to aggregate.")
    private List<String> saslServerFactories;

    public AggregateSASLServerFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="available-mechanisms")
    public List<String> availableMechanisms() {
        return this.availableMechanisms;
    }

    public T availableMechanisms(List<String> value) {
        List<String> oldValue = this.availableMechanisms;
        this.availableMechanisms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
        }
        return (T)this;
    }

    public T availableMechanism(String value) {
        if (this.availableMechanisms == null) {
            this.availableMechanisms = new ArrayList<String>();
        }
        this.availableMechanisms.add(value);
        return (T)this;
    }

    public T availableMechanisms(String ... args) {
        this.availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-server-factories")
    public List<String> saslServerFactories() {
        return this.saslServerFactories;
    }

    public T saslServerFactories(List<String> value) {
        List<String> oldValue = this.saslServerFactories;
        this.saslServerFactories = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslServerFactories", oldValue, value);
        }
        return (T)this;
    }

    public T saslServerFactory(String value) {
        if (this.saslServerFactories == null) {
            this.saslServerFactories = new ArrayList<String>();
        }
        this.saslServerFactories.add(value);
        return (T)this;
    }

    public T saslServerFactories(String ... args) {
        this.saslServerFactories(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

