/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/authentication-configuration=*")
@ResourceType(value="authentication-configuration")
public class AuthenticationConfiguration<T extends AuthenticationConfiguration<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Enables anonymous authentication.")
    private Boolean anonymous;
    @AttributeDocumentation(value="The authentication name to use.")
    private String authenticationName;
    @AttributeDocumentation(value="The authorization name to use.")
    private String authorizationName;
    @AttributeDocumentation(value="The reference to credential stored in CredentialStore under defined alias or clear text password.")
    private Map credentialReference;
    @AttributeDocumentation(value="A previously defined authentication configuration to extend.")
    private String attributeExtends;
    @AttributeDocumentation(value="The type of security identity forwarding to use. A mode of 'authentication' forwarding forwards the principal and credential. A mode of 'authorization' forwards the authorization id, allowing for a different authentication identity.")
    private ForwardingMode forwardingMode;
    @AttributeDocumentation(value="The host to use.")
    private String host;
    @AttributeDocumentation(value="Reference to a kerberos security factory used to obtain a GSS kerberos credential")
    private String kerberosSecurityFactory;
    @AttributeDocumentation(value="Configuration properties for the SASL authentication mechanism.")
    private Map mechanismProperties;
    @AttributeDocumentation(value="The port to use.")
    private Integer port;
    @AttributeDocumentation(value="The protocol to use.")
    private String protocol;
    @AttributeDocumentation(value="The realm to use.")
    private String realm;
    @AttributeDocumentation(value="The SASL mechanism selector string.")
    private String saslMechanismSelector;
    @AttributeDocumentation(value="Reference to a security domain to obtain a forwarded identity.")
    private String securityDomain;

    public AuthenticationConfiguration(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="anonymous")
    public Boolean anonymous() {
        return this.anonymous;
    }

    public T anonymous(Boolean value) {
        Boolean oldValue = this.anonymous;
        this.anonymous = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("anonymous", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-name")
    public String authenticationName() {
        return this.authenticationName;
    }

    public T authenticationName(String value) {
        String oldValue = this.authenticationName;
        this.authenticationName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authorization-name")
    public String authorizationName() {
        return this.authorizationName;
    }

    public T authorizationName(String value) {
        String oldValue = this.authorizationName;
        this.authorizationName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authorizationName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="credential-reference")
    public Map credentialReference() {
        return this.credentialReference;
    }

    public T credentialReference(Map value) {
        Map oldValue = this.credentialReference;
        this.credentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("credentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T credentialReference(String key, Object value) {
        if (this.credentialReference == null) {
            this.credentialReference = new HashMap();
        }
        this.credentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="extends")
    public String attributeExtends() {
        return this.attributeExtends;
    }

    public T attributeExtends(String value) {
        String oldValue = this.attributeExtends;
        this.attributeExtends = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeExtends", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="forwarding-mode")
    public ForwardingMode forwardingMode() {
        return this.forwardingMode;
    }

    public T forwardingMode(ForwardingMode value) {
        ForwardingMode oldValue = this.forwardingMode;
        this.forwardingMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("forwardingMode", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="host")
    public String host() {
        return this.host;
    }

    public T host(String value) {
        String oldValue = this.host;
        this.host = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("host", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="kerberos-security-factory")
    public String kerberosSecurityFactory() {
        return this.kerberosSecurityFactory;
    }

    public T kerberosSecurityFactory(String value) {
        String oldValue = this.kerberosSecurityFactory;
        this.kerberosSecurityFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("kerberosSecurityFactory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mechanism-properties")
    public Map mechanismProperties() {
        return this.mechanismProperties;
    }

    public T mechanismProperties(Map value) {
        Map oldValue = this.mechanismProperties;
        this.mechanismProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mechanismProperties", oldValue, value);
        }
        return (T)this;
    }

    public T mechanismProperty(String key, Object value) {
        if (this.mechanismProperties == null) {
            this.mechanismProperties = new HashMap();
        }
        this.mechanismProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="port")
    public Integer port() {
        return this.port;
    }

    public T port(Integer value) {
        Integer oldValue = this.port;
        this.port = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("port", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol")
    public String protocol() {
        return this.protocol;
    }

    public T protocol(String value) {
        String oldValue = this.protocol;
        this.protocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm")
    public String realm() {
        return this.realm;
    }

    public T realm(String value) {
        String oldValue = this.realm;
        this.realm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-mechanism-selector")
    public String saslMechanismSelector() {
        return this.saslMechanismSelector;
    }

    public T saslMechanismSelector(String value) {
        String oldValue = this.saslMechanismSelector;
        this.saslMechanismSelector = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslMechanismSelector", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    public static enum ForwardingMode {
        AUTHENTICATION("authentication"),
        AUTHORIZATION("authorization");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ForwardingMode(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

