/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/caching-realm=*")
@ResourceType(value="caching-realm")
public class CachingRealm<T extends CachingRealm<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The time in milliseconds that an item can stay in the cache.")
    private Long maximumAge;
    @AttributeDocumentation(value="The maximum number of entries to keep in the cache.")
    private Integer maximumEntries;
    @AttributeDocumentation(value="A reference to a cacheable security realm.")
    private String realm;

    public CachingRealm(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="maximum-age")
    public Long maximumAge() {
        return this.maximumAge;
    }

    public T maximumAge(Long value) {
        Long oldValue = this.maximumAge;
        this.maximumAge = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maximumAge", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="maximum-entries")
    public Integer maximumEntries() {
        return this.maximumEntries;
    }

    public T maximumEntries(Integer value) {
        Integer oldValue = this.maximumEntries;
        this.maximumEntries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maximumEntries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm")
    public String realm() {
        return this.realm;
    }

    public T realm(String value) {
        String oldValue = this.realm;
        this.realm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realm", oldValue, value);
        }
        return (T)this;
    }
}

