/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.elytron.State;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/credential-store=*")
@ResourceType(value="credential-store")
public class CredentialStore<T extends CredentialStore<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Specifies whether credential store should create storage when it doesn't exist.")
    private Boolean create;
    @AttributeDocumentation(value="Credential reference to be used to create protection parameter.")
    private Map credentialReference;
    @AttributeDocumentation(value="Map of credentials store implementation specific properties.")
    private Map implementationProperties;
    @AttributeDocumentation(value="File name of credential store storage.")
    private String location;
    @AttributeDocumentation(value="Specifies whether credential store is modifiable.")
    private Boolean modifiable;
    @AttributeDocumentation(value="The name of the providers defined within the subsystem to obtain the Providers to search for the one that can create the required JCA objects within credential store. This is valid only for key-store based CredentialStore. If this is not specified then the global list of Providers is used instead.")
    private String otherProviders;
    @AttributeDocumentation(value="The name of the provider to use to instantiate the CredentialStoreSpi. If the provider is not specified then the first provider found that can create an instance of the specified 'type' will be used.")
    private String providerName;
    @AttributeDocumentation(value="The name of the providers defined within the subsystem to obtain the Providers to search for the one that can create the required CredentialStore type. If this is not specified then the global list of Providers is used instead.")
    private String providers;
    @AttributeDocumentation(value="A reference to a previously defined path that the file name is relative to.")
    private String relativeTo;
    @AttributeDocumentation(value="The state of the underlying service that represents this credential store at runtime.")
    private State state;
    @AttributeDocumentation(value="The credential store type, e.g. KeyStoreCredentialStore.")
    private String type;

    public CredentialStore(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="create")
    public Boolean create() {
        return this.create;
    }

    public T create(Boolean value) {
        Boolean oldValue = this.create;
        this.create = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("create", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="credential-reference")
    public Map credentialReference() {
        return this.credentialReference;
    }

    public T credentialReference(Map value) {
        Map oldValue = this.credentialReference;
        this.credentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("credentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T credentialReference(String key, Object value) {
        if (this.credentialReference == null) {
            this.credentialReference = new HashMap();
        }
        this.credentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="implementation-properties")
    public Map implementationProperties() {
        return this.implementationProperties;
    }

    public T implementationProperties(Map value) {
        Map oldValue = this.implementationProperties;
        this.implementationProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("implementationProperties", oldValue, value);
        }
        return (T)this;
    }

    public T implementationProperty(String key, Object value) {
        if (this.implementationProperties == null) {
            this.implementationProperties = new HashMap();
        }
        this.implementationProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="location")
    public String location() {
        return this.location;
    }

    public T location(String value) {
        String oldValue = this.location;
        this.location = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("location", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="modifiable")
    public Boolean modifiable() {
        return this.modifiable;
    }

    public T modifiable(Boolean value) {
        Boolean oldValue = this.modifiable;
        this.modifiable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("modifiable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="other-providers")
    public String otherProviders() {
        return this.otherProviders;
    }

    public T otherProviders(String value) {
        String oldValue = this.otherProviders;
        this.otherProviders = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("otherProviders", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="provider-name")
    public String providerName() {
        return this.providerName;
    }

    public T providerName(String value) {
        String oldValue = this.providerName;
        this.providerName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providerName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="providers")
    public String providers() {
        return this.providers;
    }

    public T providers(String value) {
        String oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="relative-to")
    public String relativeTo() {
        return this.relativeTo;
    }

    public T relativeTo(String value) {
        String oldValue = this.relativeTo;
        this.relativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("relativeTo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="state")
    public State state() {
        return this.state;
    }

    public T state(State value) {
        State oldValue = this.state;
        this.state = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("state", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }
}

