/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/jaspi-configuration=*")
@ResourceType(value="jaspi-configuration")
public class JaspiConfiguration<T extends JaspiConfiguration<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The application-context this configuration is to be associated with or '*' for all application contexts.")
    private String applicationContext;
    @AttributeDocumentation(value="Description of this configuration.")
    private String description;
    @AttributeDocumentation(value="The layer this configuration is to be associated with or '*' for all layers.")
    private String layer;
    @AttributeDocumentation(value="List of ServerAuthModule definitions for this configuration.")
    private List<Map> serverAuthModules;

    public JaspiConfiguration(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="application-context")
    public String applicationContext() {
        return this.applicationContext;
    }

    public T applicationContext(String value) {
        String oldValue = this.applicationContext;
        this.applicationContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("applicationContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="description")
    public String description() {
        return this.description;
    }

    public T description(String value) {
        String oldValue = this.description;
        this.description = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("description", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="layer")
    public String layer() {
        return this.layer;
    }

    public T layer(String value) {
        String oldValue = this.layer;
        this.layer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("layer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-auth-modules")
    public List<Map> serverAuthModules() {
        return this.serverAuthModules;
    }

    public T serverAuthModules(List<Map> value) {
        List<Map> oldValue = this.serverAuthModules;
        this.serverAuthModules = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverAuthModules", oldValue, value);
        }
        return (T)this;
    }

    public T serverAuthModule(Map value) {
        if (this.serverAuthModules == null) {
            this.serverAuthModules = new ArrayList<Map>();
        }
        this.serverAuthModules.add(value);
        return (T)this;
    }

    public T serverAuthModules(Map ... args) {
        this.serverAuthModules(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

