/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.elytron.State;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/ldap-key-store=*")
@ResourceType(value="ldap-key-store")
public class LdapKeyStore<T extends LdapKeyStore<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of LDAP attribute, where will be item alias stored.")
    private String aliasAttribute;
    @AttributeDocumentation(value="The name of LDAP attribute, where will be certificate stored.")
    private String certificateAttribute;
    @AttributeDocumentation(value="The name of LDAP attribute, where will be certificate chain stored.")
    private String certificateChainAttribute;
    @AttributeDocumentation(value="The encoding of the certificate chain.")
    private String certificateChainEncoding;
    @AttributeDocumentation(value="The type of the Certificate.")
    private String certificateType;
    @AttributeDocumentation(value="The name of DirContext, which will be used to communication with LDAP server.")
    private String dirContext;
    @AttributeDocumentation(value="The LDAP filter for obtaining an item of the KeyStore by alias. If this is not specified then the default value will be (alias_attribute={0}). The string '{0}' will be replaced by the searched alias and the 'alias_attribute' value will be the value of the attribute 'alias-attribute'.")
    private String filterAlias;
    @AttributeDocumentation(value="The LDAP filter for obtaining an item of the KeyStore by certificate. If this is not specified then the default value will be (certificate_attribute={0}). The string '{0}' will be replaced by searched encoded certificate and the 'certificate_attribute' will be the value of the attribute 'certificate-attribute'.")
    private String filterCertificate;
    @AttributeDocumentation(value="The LDAP filter for iterating over all items of the KeyStore. If this is not specified then the default value will be (alias_attribute=*). The 'alias_attribute' will be the value of the attribute 'alias-attribute'.")
    private String filterIterate;
    @AttributeDocumentation(value="The name of LDAP attribute, where will be key stored.")
    private String keyAttribute;
    @AttributeDocumentation(value="The type of KeyStore, in which will be key serialized to LDAP attribute.")
    private String keyType;
    @AttributeDocumentation(value="Configuration for item creation. Define how will look LDAP entry of newly created keystore item.")
    private Map newItemTemplate;
    @AttributeDocumentation(value="The path in LDAP, where will be KeyStore items searched.")
    private String searchPath;
    @AttributeDocumentation(value="If the LDAP search should be recursive.")
    private Boolean searchRecursive;
    @AttributeDocumentation(value="The time limit for obtaining keystore items from LDAP.")
    private Integer searchTimeLimit;
    @AttributeDocumentation(value="The size of LDAP KeyStore in amount of items/aliases.")
    private Integer size;
    @AttributeDocumentation(value="The state of the underlying service that represents this KeyStore at runtime, if it is anything other than UP runtime operations will not be available.")
    private State state;

    public LdapKeyStore(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="alias-attribute")
    public String aliasAttribute() {
        return this.aliasAttribute;
    }

    public T aliasAttribute(String value) {
        String oldValue = this.aliasAttribute;
        this.aliasAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("aliasAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="certificate-attribute")
    public String certificateAttribute() {
        return this.certificateAttribute;
    }

    public T certificateAttribute(String value) {
        String oldValue = this.certificateAttribute;
        this.certificateAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("certificateAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="certificate-chain-attribute")
    public String certificateChainAttribute() {
        return this.certificateChainAttribute;
    }

    public T certificateChainAttribute(String value) {
        String oldValue = this.certificateChainAttribute;
        this.certificateChainAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("certificateChainAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="certificate-chain-encoding")
    public String certificateChainEncoding() {
        return this.certificateChainEncoding;
    }

    public T certificateChainEncoding(String value) {
        String oldValue = this.certificateChainEncoding;
        this.certificateChainEncoding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("certificateChainEncoding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="certificate-type")
    public String certificateType() {
        return this.certificateType;
    }

    public T certificateType(String value) {
        String oldValue = this.certificateType;
        this.certificateType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("certificateType", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="dir-context")
    public String dirContext() {
        return this.dirContext;
    }

    public T dirContext(String value) {
        String oldValue = this.dirContext;
        this.dirContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dirContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter-alias")
    public String filterAlias() {
        return this.filterAlias;
    }

    public T filterAlias(String value) {
        String oldValue = this.filterAlias;
        this.filterAlias = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filterAlias", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter-certificate")
    public String filterCertificate() {
        return this.filterCertificate;
    }

    public T filterCertificate(String value) {
        String oldValue = this.filterCertificate;
        this.filterCertificate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filterCertificate", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter-iterate")
    public String filterIterate() {
        return this.filterIterate;
    }

    public T filterIterate(String value) {
        String oldValue = this.filterIterate;
        this.filterIterate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filterIterate", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-attribute")
    public String keyAttribute() {
        return this.keyAttribute;
    }

    public T keyAttribute(String value) {
        String oldValue = this.keyAttribute;
        this.keyAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-type")
    public String keyType() {
        return this.keyType;
    }

    public T keyType(String value) {
        String oldValue = this.keyType;
        this.keyType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyType", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="new-item-template")
    public Map newItemTemplate() {
        return this.newItemTemplate;
    }

    public T newItemTemplate(Map value) {
        Map oldValue = this.newItemTemplate;
        this.newItemTemplate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("newItemTemplate", oldValue, value);
        }
        return (T)this;
    }

    public T newItemTemplate(String key, Object value) {
        if (this.newItemTemplate == null) {
            this.newItemTemplate = new HashMap();
        }
        this.newItemTemplate.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="search-path")
    public String searchPath() {
        return this.searchPath;
    }

    public T searchPath(String value) {
        String oldValue = this.searchPath;
        this.searchPath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("searchPath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="search-recursive")
    public Boolean searchRecursive() {
        return this.searchRecursive;
    }

    public T searchRecursive(Boolean value) {
        Boolean oldValue = this.searchRecursive;
        this.searchRecursive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("searchRecursive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="search-time-limit")
    public Integer searchTimeLimit() {
        return this.searchTimeLimit;
    }

    public T searchTimeLimit(Integer value) {
        Integer oldValue = this.searchTimeLimit;
        this.searchTimeLimit = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("searchTimeLimit", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="size")
    public Integer size() {
        return this.size;
    }

    public T size(Integer value) {
        Integer oldValue = this.size;
        this.size = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("size", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="state")
    public State state() {
        return this.state;
    }

    public T state(State value) {
        State oldValue = this.state;
        this.state = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("state", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }
}

