/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=elytron/client-ssl-context=*/ssl-session=*", "/subsystem=elytron/server-ssl-context=*/ssl-session=*"})
@ResourceType(value="ssl-session")
public class SslSession<T extends SslSession<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The application buffer size as reported by the SSLSession.")
    private Integer applicationBufferSize;
    @AttributeDocumentation(value="The selected cipher suite as reported by the SSLSession.")
    private String cipherSuite;
    @AttributeDocumentation(value="The creation time as reported by the SSLSession.")
    private String creationTime;
    @AttributeDocumentation(value="The last accessed time as reported by the SSLSession.")
    private String lastAccessedTime;
    @AttributeDocumentation(value="The local certificates from the SSLSession.")
    private List<Map> localCertificates;
    @AttributeDocumentation(value="The local principal as reported by the SSLSession.")
    private String localPrincipal;
    @AttributeDocumentation(value="The packet buffer size as reported by the SSLSession.")
    private Integer packetBufferSize;
    @AttributeDocumentation(value="The peer certificates from the SSLSession.")
    private List<Map> peerCertificates;
    @AttributeDocumentation(value="The peer host as reported by the SSLSession.")
    private String peerHost;
    @AttributeDocumentation(value="The peer port as reported by the SSLSession.")
    private Integer peerPort;
    @AttributeDocumentation(value="The peer principal as reported by the SSLSession.")
    private String peerPrincipal;
    @AttributeDocumentation(value="The protocol as reported by the SSLSession.")
    private String protocol;
    @AttributeDocumentation(value="The validity of the session as reported by the SSLSession.")
    private Boolean valid;

    public SslSession(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="application-buffer-size")
    public Integer applicationBufferSize() {
        return this.applicationBufferSize;
    }

    public T applicationBufferSize(Integer value) {
        Integer oldValue = this.applicationBufferSize;
        this.applicationBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("applicationBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cipher-suite")
    public String cipherSuite() {
        return this.cipherSuite;
    }

    public T cipherSuite(String value) {
        String oldValue = this.cipherSuite;
        this.cipherSuite = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cipherSuite", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="creation-time")
    public String creationTime() {
        return this.creationTime;
    }

    public T creationTime(String value) {
        String oldValue = this.creationTime;
        this.creationTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("creationTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="last-accessed-time")
    public String lastAccessedTime() {
        return this.lastAccessedTime;
    }

    public T lastAccessedTime(String value) {
        String oldValue = this.lastAccessedTime;
        this.lastAccessedTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("lastAccessedTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="local-certificates")
    public List<Map> localCertificates() {
        return this.localCertificates;
    }

    public T localCertificates(List<Map> value) {
        List<Map> oldValue = this.localCertificates;
        this.localCertificates = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("localCertificates", oldValue, value);
        }
        return (T)this;
    }

    public T localCertificate(Map value) {
        if (this.localCertificates == null) {
            this.localCertificates = new ArrayList<Map>();
        }
        this.localCertificates.add(value);
        return (T)this;
    }

    public T localCertificates(Map ... args) {
        this.localCertificates(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="local-principal")
    public String localPrincipal() {
        return this.localPrincipal;
    }

    public T localPrincipal(String value) {
        String oldValue = this.localPrincipal;
        this.localPrincipal = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("localPrincipal", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="packet-buffer-size")
    public Integer packetBufferSize() {
        return this.packetBufferSize;
    }

    public T packetBufferSize(Integer value) {
        Integer oldValue = this.packetBufferSize;
        this.packetBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("packetBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="peer-certificates")
    public List<Map> peerCertificates() {
        return this.peerCertificates;
    }

    public T peerCertificates(List<Map> value) {
        List<Map> oldValue = this.peerCertificates;
        this.peerCertificates = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("peerCertificates", oldValue, value);
        }
        return (T)this;
    }

    public T peerCertificate(Map value) {
        if (this.peerCertificates == null) {
            this.peerCertificates = new ArrayList<Map>();
        }
        this.peerCertificates.add(value);
        return (T)this;
    }

    public T peerCertificates(Map ... args) {
        this.peerCertificates(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="peer-host")
    public String peerHost() {
        return this.peerHost;
    }

    public T peerHost(String value) {
        String oldValue = this.peerHost;
        this.peerHost = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("peerHost", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="peer-port")
    public Integer peerPort() {
        return this.peerPort;
    }

    public T peerPort(Integer value) {
        Integer oldValue = this.peerPort;
        this.peerPort = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("peerPort", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="peer-principal")
    public String peerPrincipal() {
        return this.peerPrincipal;
    }

    public T peerPrincipal(String value) {
        String oldValue = this.peerPrincipal;
        this.peerPrincipal = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("peerPrincipal", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol")
    public String protocol() {
        return this.protocol;
    }

    public T protocol(String value) {
        String oldValue = this.protocol;
        this.protocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="valid")
    public Boolean valid() {
        return this.valid;
    }

    public T valid(Boolean value) {
        Boolean oldValue = this.valid;
        this.valid = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("valid", oldValue, value);
        }
        return (T)this;
    }
}

