/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/x500-attribute-principal-decoder=*")
@ResourceType(value="x500-attribute-principal-decoder")
public class X500AttributePrincipalDecoder<T extends X500AttributePrincipalDecoder<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the X.500 attribute to map (can be defined using OID instead)")
    private String attributeName;
    @AttributeDocumentation(value="When set to 'true', if the Principal is not already an X500Principal conversion will be attempted")
    private Boolean convert;
    @AttributeDocumentation(value="The joining string")
    private String joiner;
    @AttributeDocumentation(value="The maximum number of occurrences of the attribute to map")
    private Integer maximumSegments;
    @AttributeDocumentation(value="The OID of the X.500 attribute to map (can be defined using attribute name instead)")
    private String oid;
    @AttributeDocumentation(value="The attributes names of the attributes that must be present in the principal")
    private List<String> requiredAttributes;
    @AttributeDocumentation(value="The OIDs of the attributes that must be present in the principal")
    private List<String> requiredOids;
    @AttributeDocumentation(value="When set to 'true', the attribute values will be processed and returned in reverse order")
    private Boolean reverse;
    @AttributeDocumentation(value="The 0-based starting occurrence of the attribute to map")
    private Integer startSegment;

    public X500AttributePrincipalDecoder(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="attribute-name")
    public String attributeName() {
        return this.attributeName;
    }

    public T attributeName(String value) {
        String oldValue = this.attributeName;
        this.attributeName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="convert")
    public Boolean convert() {
        return this.convert;
    }

    public T convert(Boolean value) {
        Boolean oldValue = this.convert;
        this.convert = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("convert", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="joiner")
    public String joiner() {
        return this.joiner;
    }

    public T joiner(String value) {
        String oldValue = this.joiner;
        this.joiner = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("joiner", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="maximum-segments")
    public Integer maximumSegments() {
        return this.maximumSegments;
    }

    public T maximumSegments(Integer value) {
        Integer oldValue = this.maximumSegments;
        this.maximumSegments = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maximumSegments", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="oid")
    public String oid() {
        return this.oid;
    }

    public T oid(String value) {
        String oldValue = this.oid;
        this.oid = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("oid", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="required-attributes")
    public List<String> requiredAttributes() {
        return this.requiredAttributes;
    }

    public T requiredAttributes(List<String> value) {
        List<String> oldValue = this.requiredAttributes;
        this.requiredAttributes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requiredAttributes", oldValue, value);
        }
        return (T)this;
    }

    public T requiredAttribute(String value) {
        if (this.requiredAttributes == null) {
            this.requiredAttributes = new ArrayList<String>();
        }
        this.requiredAttributes.add(value);
        return (T)this;
    }

    public T requiredAttributes(String ... args) {
        this.requiredAttributes(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="required-oids")
    public List<String> requiredOids() {
        return this.requiredOids;
    }

    public T requiredOids(List<String> value) {
        List<String> oldValue = this.requiredOids;
        this.requiredOids = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requiredOids", oldValue, value);
        }
        return (T)this;
    }

    public T requiredOid(String value) {
        if (this.requiredOids == null) {
            this.requiredOids = new ArrayList<String>();
        }
        this.requiredOids.add(value);
        return (T)this;
    }

    public T requiredOids(String ... args) {
        this.requiredOids(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reverse")
    public Boolean reverse() {
        return this.reverse;
    }

    public T reverse(Boolean value) {
        Boolean oldValue = this.reverse;
        this.reverse = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reverse", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="start-segment")
    public Integer startSegment() {
        return this.startSegment;
    }

    public T startSegment(Integer value) {
        Integer oldValue = this.startSegment;
        this.startSegment = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("startSegment", oldValue, value);
        }
        return (T)this;
    }
}

