/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=infinispan/cache-container=*/invalidation-cache=*/component=expiration", "/subsystem=infinispan/cache-container=*/local-cache=*/component=expiration", "/subsystem=infinispan/cache-container=*/replicated-cache=*/component=expiration", "/subsystem=infinispan/cache-container=*/distributed-cache=*/component=expiration", "/subsystem=infinispan/cache-container=*/scattered-cache=*/component=expiration"})
@ResourceType(value="component")
@Implicit
public class ExpirationComponent<T extends ExpirationComponent<T>>
implements Keyed {
    private String key = "expiration";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="Interval (in milliseconds) between subsequent runs to purge expired entries from memory and any cache stores. If you wish to disable the periodic eviction process altogether, set wakeupInterval to -1.")
    private Long interval;
    @AttributeDocumentation(value="Maximum lifespan of a cache entry, after which the entry is expired cluster-wide, in milliseconds. -1 means the entries never expire.")
    private Long lifespan;
    @AttributeDocumentation(value="Maximum idle time a cache entry will be maintained in the cache, in milliseconds. If the idle time is exceeded, the entry will be expired cluster-wide. -1 means the entries never expire.")
    private Long maxIdle;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="interval")
    public Long interval() {
        return this.interval;
    }

    public T interval(Long value) {
        Long oldValue = this.interval;
        this.interval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("interval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="lifespan")
    public Long lifespan() {
        return this.lifespan;
    }

    public T lifespan(Long value) {
        Long oldValue = this.lifespan;
        this.lifespan = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("lifespan", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-idle")
    public Long maxIdle() {
        return this.maxIdle;
    }

    public T maxIdle(Long value) {
        Long oldValue = this.maxIdle;
        this.maxIdle = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxIdle", oldValue, value);
        }
        return (T)this;
    }
}

