/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.infinispan.EvictionType;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=infinispan/cache-container=*/invalidation-cache=*/memory=off-heap", "/subsystem=infinispan/cache-container=*/local-cache=*/memory=off-heap", "/subsystem=infinispan/cache-container=*/replicated-cache=*/memory=off-heap", "/subsystem=infinispan/cache-container=*/distributed-cache=*/memory=off-heap", "/subsystem=infinispan/cache-container=*/scattered-cache=*/memory=off-heap"})
@ResourceType(value="memory")
@Implicit
public class OffHeapMemory<T extends OffHeapMemory<T>>
implements Keyed {
    private String key = "off-heap";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="Defines the capacity of the off-heap storage.")
    private Integer capacity;
    @AttributeDocumentation(value="Indicates whether the size attribute refers to the number of cache entries (i.e. COUNT) or the collective size of the cache entries (i.e. MEMORY).")
    private EvictionType evictionType;
    @AttributeDocumentation(value="The number of cache eviction operations. May return null if the cache is not started.")
    private Long evictions;
    @AttributeDocumentation(value="Eviction threshold, as defined by the eviction-type.")
    private Long size;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="capacity")
    public Integer capacity() {
        return this.capacity;
    }

    public T capacity(Integer value) {
        Integer oldValue = this.capacity;
        this.capacity = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacity", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="eviction-type")
    public EvictionType evictionType() {
        return this.evictionType;
    }

    public T evictionType(EvictionType value) {
        EvictionType oldValue = this.evictionType;
        this.evictionType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("evictionType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="evictions")
    public Long evictions() {
        return this.evictions;
    }

    public T evictions(Long value) {
        Long oldValue = this.evictions;
        this.evictions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("evictions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="size")
    public Long size() {
        return this.size;
    }

    public T size(Long value) {
        Long oldValue = this.size;
        this.size = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("size", oldValue, value);
        }
        return (T)this;
    }
}

