/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=custom/property=*", "/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=hotrod/property=*", "/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=binary-jdbc/property=*", "/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=file/property=*", "/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=jdbc/property=*", "/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=mixed-jdbc/property=*", "/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=remote/property=*", "/subsystem=infinispan/cache-container=*/local-cache=*/store=custom/property=*", "/subsystem=infinispan/cache-container=*/local-cache=*/store=hotrod/property=*", "/subsystem=infinispan/cache-container=*/local-cache=*/store=binary-jdbc/property=*", "/subsystem=infinispan/cache-container=*/local-cache=*/store=file/property=*", "/subsystem=infinispan/cache-container=*/local-cache=*/store=jdbc/property=*", "/subsystem=infinispan/cache-container=*/local-cache=*/store=mixed-jdbc/property=*", "/subsystem=infinispan/cache-container=*/local-cache=*/store=remote/property=*", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=custom/property=*", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=hotrod/property=*", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=binary-jdbc/property=*", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=file/property=*", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=jdbc/property=*", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=mixed-jdbc/property=*", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=remote/property=*", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=custom/property=*", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=hotrod/property=*", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=binary-jdbc/property=*", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=file/property=*", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=jdbc/property=*", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=mixed-jdbc/property=*", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=remote/property=*", "/subsystem=infinispan/cache-container=*/scattered-cache=*/store=custom/property=*", "/subsystem=infinispan/cache-container=*/scattered-cache=*/store=hotrod/property=*", "/subsystem=infinispan/cache-container=*/scattered-cache=*/store=binary-jdbc/property=*", "/subsystem=infinispan/cache-container=*/scattered-cache=*/store=file/property=*", "/subsystem=infinispan/cache-container=*/scattered-cache=*/store=jdbc/property=*", "/subsystem=infinispan/cache-container=*/scattered-cache=*/store=mixed-jdbc/property=*", "/subsystem=infinispan/cache-container=*/scattered-cache=*/store=remote/property=*"})
@ResourceType(value="property")
public class Property<T extends Property<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The value of the cache store property.")
    private String value;

    public Property(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="value")
    public String value() {
        return this.value;
    }

    public T value(String value) {
        String oldValue = this.value;
        this.value = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("value", oldValue, value);
        }
        return (T)this;
    }
}

