/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.io;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.io.worker.OutboundBindAddress;
import org.wildfly.swarm.config.io.worker.OutboundBindAddressConsumer;
import org.wildfly.swarm.config.io.worker.OutboundBindAddressSupplier;
import org.wildfly.swarm.config.io.worker.Server;
import org.wildfly.swarm.config.io.worker.ServerConsumer;
import org.wildfly.swarm.config.io.worker.ServerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=io/worker=*")
@ResourceType(value="worker")
public class Worker<T extends Worker<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private WorkerResources subresources = new WorkerResources();
    @AttributeDocumentation(value="An estimate of busy threads in the task worker thread pool")
    private Integer busyTaskThreadCount;
    @AttributeDocumentation(value="Minimum number of threads to keep in the underlying thread pool even if they are idle. Threads over this limit will be terminated over time specified by task-keepalive attribute.")
    private Integer corePoolSize;
    @AttributeDocumentation(value="I/O thread count")
    private Integer ioThreadCount;
    @AttributeDocumentation(value="Specify the number of I/O threads to create for the worker.  If not specified, a default will be chosen, which is calculated by cpuCount * 2")
    private Integer ioThreads;
    @AttributeDocumentation(value="The maximum number of threads to allow in the thread pool. Depending on implementation, when this limit is reached, tasks which cannot be queued may be rejected.")
    private Integer maxPoolSize;
    @AttributeDocumentation(value="An estimate of the number of tasks in the worker queue.")
    private Integer queueSize;
    @AttributeDocumentation(value="True is shutdown of the pool was requested")
    private Boolean shutdownRequested;
    @AttributeDocumentation(value="The stack size (in bytes) to attempt to use for worker threads.")
    private Long stackSize;
    @AttributeDocumentation(value="Specify the starting number of threads for the worker task thread pool.")
    private Integer taskCoreThreads;
    @AttributeDocumentation(value="Specify the number of milliseconds to keep non-core task threads alive.")
    private Integer taskKeepalive;
    @AttributeDocumentation(value="Specify the maximum number of threads for the worker task thread pool.If not set, default value used which is calculated by formula cpuCount * 16,as long as MaxFileDescriptorCount jmx property allows that number, otherwise calculation takes max into account to adjust it accordingly.")
    private Integer taskMaxThreads;

    public Worker(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public WorkerResources subresources() {
        return this.subresources;
    }

    public T servers(List<Server> value) {
        this.subresources.servers = value;
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T server(String childKey, ServerConsumer consumer) {
        Server child = new Server(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.server(child);
        return (T)this;
    }

    public T server(String childKey) {
        this.server(childKey, null);
        return (T)this;
    }

    public T server(ServerSupplier supplier) {
        this.server(supplier.get());
        return (T)this;
    }

    public T outboundBindAddress(List<OutboundBindAddress> value) {
        this.subresources.outboundBindAddress = value;
        return (T)this;
    }

    public T outboundBindAddress(OutboundBindAddress value) {
        this.subresources.outboundBindAddress.add(value);
        return (T)this;
    }

    public T outboundBindAddress(String childKey, OutboundBindAddressConsumer consumer) {
        OutboundBindAddress child = new OutboundBindAddress(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.outboundBindAddress(child);
        return (T)this;
    }

    public T outboundBindAddress(String childKey) {
        this.outboundBindAddress(childKey, null);
        return (T)this;
    }

    public T outboundBindAddress(OutboundBindAddressSupplier supplier) {
        this.outboundBindAddress(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="busy-task-thread-count")
    public Integer busyTaskThreadCount() {
        return this.busyTaskThreadCount;
    }

    public T busyTaskThreadCount(Integer value) {
        Integer oldValue = this.busyTaskThreadCount;
        this.busyTaskThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("busyTaskThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="core-pool-size")
    public Integer corePoolSize() {
        return this.corePoolSize;
    }

    public T corePoolSize(Integer value) {
        Integer oldValue = this.corePoolSize;
        this.corePoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("corePoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="io-thread-count")
    public Integer ioThreadCount() {
        return this.ioThreadCount;
    }

    public T ioThreadCount(Integer value) {
        Integer oldValue = this.ioThreadCount;
        this.ioThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ioThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="io-threads")
    public Integer ioThreads() {
        return this.ioThreads;
    }

    public T ioThreads(Integer value) {
        Integer oldValue = this.ioThreads;
        this.ioThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ioThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-pool-size")
    public Integer maxPoolSize() {
        return this.maxPoolSize;
    }

    public T maxPoolSize(Integer value) {
        Integer oldValue = this.maxPoolSize;
        this.maxPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-size")
    public Integer queueSize() {
        return this.queueSize;
    }

    public T queueSize(Integer value) {
        Integer oldValue = this.queueSize;
        this.queueSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="shutdown-requested")
    public Boolean shutdownRequested() {
        return this.shutdownRequested;
    }

    public T shutdownRequested(Boolean value) {
        Boolean oldValue = this.shutdownRequested;
        this.shutdownRequested = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("shutdownRequested", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stack-size")
    public Long stackSize() {
        return this.stackSize;
    }

    public T stackSize(Long value) {
        Long oldValue = this.stackSize;
        this.stackSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stackSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="task-core-threads")
    public Integer taskCoreThreads() {
        return this.taskCoreThreads;
    }

    public T taskCoreThreads(Integer value) {
        Integer oldValue = this.taskCoreThreads;
        this.taskCoreThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("taskCoreThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="task-keepalive")
    public Integer taskKeepalive() {
        return this.taskKeepalive;
    }

    public T taskKeepalive(Integer value) {
        Integer oldValue = this.taskKeepalive;
        this.taskKeepalive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("taskKeepalive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="task-max-threads")
    public Integer taskMaxThreads() {
        return this.taskMaxThreads;
    }

    public T taskMaxThreads(Integer value) {
        Integer oldValue = this.taskMaxThreads;
        this.taskMaxThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("taskMaxThreads", oldValue, value);
        }
        return (T)this;
    }

    public static class WorkerResources {
        @ResourceDocumentation(value="Runtime resource that describes listening servers utilizing this worker")
        @SubresourceInfo(value="server")
        private List<Server> servers = new ArrayList<Server>();
        @ResourceDocumentation(value="Defines a bind address to use when connecting to the specified destination")
        @SubresourceInfo(value="outboundBindAddress")
        private List<OutboundBindAddress> outboundBindAddress = new ArrayList<OutboundBindAddress>();

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        public Server server(String key) {
            return this.servers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<OutboundBindAddress> outboundBindAddress() {
            return this.outboundBindAddress;
        }

        public OutboundBindAddress outboundBindAddress(String key) {
            return this.outboundBindAddress.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

