/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.io.worker;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=io/worker=*/server=*")
@ResourceType(value="server")
public class Server<T extends Server<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Estimate of the current connection count")
    private Integer connectionCount;
    @AttributeDocumentation(value="If the connection count hits this number, no new connections will be accepted until the count drops below the low-water mark.")
    private Integer connectionLimitHighWaterMark;
    @AttributeDocumentation(value="If the connection count has previously hit the high water mark, once it drops back down below this count, connections will be accepted again.")
    private Integer connectionLimitLowWaterMark;

    public Server(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="connection-count")
    public Integer connectionCount() {
        return this.connectionCount;
    }

    public T connectionCount(Integer value) {
        Integer oldValue = this.connectionCount;
        this.connectionCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-limit-high-water-mark")
    public Integer connectionLimitHighWaterMark() {
        return this.connectionLimitHighWaterMark;
    }

    public T connectionLimitHighWaterMark(Integer value) {
        Integer oldValue = this.connectionLimitHighWaterMark;
        this.connectionLimitHighWaterMark = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionLimitHighWaterMark", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-limit-low-water-mark")
    public Integer connectionLimitLowWaterMark() {
        return this.connectionLimitLowWaterMark;
    }

    public T connectionLimitLowWaterMark(Integer value) {
        Integer oldValue = this.connectionLimitLowWaterMark;
        this.connectionLimitLowWaterMark = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionLimitLowWaterMark", oldValue, value);
        }
        return (T)this;
    }
}

