/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.jgroups.channel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.jgroups.Protocol;
import org.wildfly.swarm.config.jgroups.ProtocolConsumer;
import org.wildfly.swarm.config.jgroups.ProtocolSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=jgroups/channel=*/fork=*")
@ResourceType(value="fork")
public class Fork<T extends Fork<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ForkResources subresources = new ForkResources();

    public Fork(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ForkResources subresources() {
        return this.subresources;
    }

    public T protocols(List<Protocol> value) {
        this.subresources.protocols = value;
        return (T)this;
    }

    public T protocol(Protocol value) {
        this.subresources.protocols.add(value);
        return (T)this;
    }

    public T protocol(String childKey, ProtocolConsumer consumer) {
        Protocol child = new Protocol(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.protocol(child);
        return (T)this;
    }

    public T protocol(String childKey) {
        this.protocol(childKey, null);
        return (T)this;
    }

    public T protocol(ProtocolSupplier supplier) {
        this.protocol(supplier.get());
        return (T)this;
    }

    public static class ForkResources {
        @ResourceDocumentation(value="The configuration of a protocol within a protocol stack.")
        @SubresourceInfo(value="protocol")
        private List<Protocol> protocols = new ArrayList<Protocol>();

        @Subresource
        public List<Protocol> protocols() {
            return this.protocols;
        }

        public Protocol protocol(String key) {
            return this.protocols.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

