/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/access=audit/in-memory-handler=*")
@ResourceType(value="in-memory-handler")
public class InMemoryHandler<T extends InMemoryHandler<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The maximum number of operation stored in history for this handler.")
    private Integer maxHistory;

    public InMemoryHandler(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="max-history")
    public Integer maxHistory() {
        return this.maxHistory;
    }

    public T maxHistory(Integer value) {
        Integer oldValue = this.maxHistory;
        this.maxHistory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxHistory", oldValue, value);
        }
        return (T)this;
    }
}

