/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access.syslog_handler;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.management.access.syslog_handler.protocol.ClientCertificateStoreAuthentication;
import org.wildfly.swarm.config.management.access.syslog_handler.protocol.ClientCertificateStoreAuthenticationConsumer;
import org.wildfly.swarm.config.management.access.syslog_handler.protocol.ClientCertificateStoreAuthenticationSupplier;
import org.wildfly.swarm.config.management.access.syslog_handler.protocol.TruststoreAuthentication;
import org.wildfly.swarm.config.management.access.syslog_handler.protocol.TruststoreAuthenticationConsumer;
import org.wildfly.swarm.config.management.access.syslog_handler.protocol.TruststoreAuthenticationSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/access=audit/syslog-handler=*/protocol=tls")
@ResourceType(value="protocol")
@Implicit
public class TlsProtocol<T extends TlsProtocol<T>>
implements Keyed {
    private String key = "tls";
    private PropertyChangeSupport pcs;
    private TlsProtocolResources subresources = new TlsProtocolResources();
    @AttributeDocumentation(value="The host of the syslog server for the tls over tcp requests.")
    private String host;
    @AttributeDocumentation(value="The message transfer setting as described in section 3.4 of RFC-6587. This can either be OCTET_COUNTING as described in section 3.4.1 of RFC-6587, or NON_TRANSPARENT_FRAMING as described in section 3.4.1 of RFC-6587. See your syslog provider's documentation for what is supported.")
    private String messageTransfer;
    @AttributeDocumentation(value="The port of the syslog server for the tls over tcp requests.")
    private Integer port;
    @AttributeDocumentation(value="If a connection drop is detected, the number of seconds to wait before reconnecting. A negative number means don't reconnect automatically.")
    private Integer reconnectTimeout;

    public TlsProtocol() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public TlsProtocolResources subresources() {
        return this.subresources;
    }

    public T truststoreAuthentication(TruststoreAuthentication value) {
        this.subresources.truststoreAuthentication = value;
        return (T)this;
    }

    public T truststoreAuthentication(TruststoreAuthenticationConsumer consumer) {
        TruststoreAuthentication child = new TruststoreAuthentication();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.truststoreAuthentication = child;
        return (T)this;
    }

    public T truststoreAuthentication() {
        TruststoreAuthentication child = new TruststoreAuthentication();
        this.subresources.truststoreAuthentication = child;
        return (T)this;
    }

    public T truststoreAuthentication(TruststoreAuthenticationSupplier supplier) {
        this.subresources.truststoreAuthentication = supplier.get();
        return (T)this;
    }

    public T clientCertificateStoreAuthentication(ClientCertificateStoreAuthentication value) {
        this.subresources.clientCertificateStoreAuthentication = value;
        return (T)this;
    }

    public T clientCertificateStoreAuthentication(ClientCertificateStoreAuthenticationConsumer consumer) {
        ClientCertificateStoreAuthentication child = new ClientCertificateStoreAuthentication();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.clientCertificateStoreAuthentication = child;
        return (T)this;
    }

    public T clientCertificateStoreAuthentication() {
        ClientCertificateStoreAuthentication child = new ClientCertificateStoreAuthentication();
        this.subresources.clientCertificateStoreAuthentication = child;
        return (T)this;
    }

    public T clientCertificateStoreAuthentication(ClientCertificateStoreAuthenticationSupplier supplier) {
        this.subresources.clientCertificateStoreAuthentication = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="host")
    public String host() {
        return this.host;
    }

    public T host(String value) {
        String oldValue = this.host;
        this.host = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("host", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-transfer")
    public String messageTransfer() {
        return this.messageTransfer;
    }

    public T messageTransfer(String value) {
        String oldValue = this.messageTransfer;
        this.messageTransfer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageTransfer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="port")
    public Integer port() {
        return this.port;
    }

    public T port(Integer value) {
        Integer oldValue = this.port;
        this.port = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("port", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reconnect-timeout")
    public Integer reconnectTimeout() {
        return this.reconnectTimeout;
    }

    public T reconnectTimeout(Integer value) {
        Integer oldValue = this.reconnectTimeout;
        this.reconnectTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reconnectTimeout", oldValue, value);
        }
        return (T)this;
    }

    public static class TlsProtocolResources {
        @SingletonResource
        @ResourceDocumentation(value="Configuration for the truststore for the server certificate, if not signed by an authority.")
        private TruststoreAuthentication truststoreAuthentication;
        @SingletonResource
        @ResourceDocumentation(value="Configuration for the keystore containing the client certificate if the syslog server requires authentication.")
        private ClientCertificateStoreAuthentication clientCertificateStoreAuthentication;

        @Subresource
        public TruststoreAuthentication truststoreAuthentication() {
            return this.truststoreAuthentication;
        }

        @Subresource
        public ClientCertificateStoreAuthentication clientCertificateStoreAuthentication() {
            return this.clientCertificateStoreAuthentication;
        }
    }
}

