/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.security_realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.management.security_realm.authorization.AdvancedFilterUsernameToDn;
import org.wildfly.swarm.config.management.security_realm.authorization.AdvancedFilterUsernameToDnConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.AdvancedFilterUsernameToDnSupplier;
import org.wildfly.swarm.config.management.security_realm.authorization.GroupToPrincipalGroupSearch;
import org.wildfly.swarm.config.management.security_realm.authorization.GroupToPrincipalGroupSearchConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.GroupToPrincipalGroupSearchSupplier;
import org.wildfly.swarm.config.management.security_realm.authorization.PrincipalToGroupGroupSearch;
import org.wildfly.swarm.config.management.security_realm.authorization.PrincipalToGroupGroupSearchConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.PrincipalToGroupGroupSearchSupplier;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameFilterUsernameToDn;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameFilterUsernameToDnConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameFilterUsernameToDnSupplier;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameIsDnUsernameToDn;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameIsDnUsernameToDnConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameIsDnUsernameToDnSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/security-realm=*/authorization=ldap")
@ResourceType(value="authorization")
@Implicit
public class LdapAuthorization<T extends LdapAuthorization<T>>
implements Keyed {
    private String key = "ldap";
    private PropertyChangeSupport pcs;
    private LdapAuthorizationResources subresources = new LdapAuthorizationResources();
    @AttributeDocumentation(value="The name of the connection to use to connect to LDAP.")
    private String connection;

    public LdapAuthorization() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public LdapAuthorizationResources subresources() {
        return this.subresources;
    }

    public T usernameFilterUsernameToDn(UsernameFilterUsernameToDn value) {
        this.subresources.usernameFilterUsernameToDn = value;
        return (T)this;
    }

    public T usernameFilterUsernameToDn(UsernameFilterUsernameToDnConsumer consumer) {
        UsernameFilterUsernameToDn child = new UsernameFilterUsernameToDn();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.usernameFilterUsernameToDn = child;
        return (T)this;
    }

    public T usernameFilterUsernameToDn() {
        UsernameFilterUsernameToDn child = new UsernameFilterUsernameToDn();
        this.subresources.usernameFilterUsernameToDn = child;
        return (T)this;
    }

    public T usernameFilterUsernameToDn(UsernameFilterUsernameToDnSupplier supplier) {
        this.subresources.usernameFilterUsernameToDn = supplier.get();
        return (T)this;
    }

    public T groupToPrincipalGroupSearch(GroupToPrincipalGroupSearch value) {
        this.subresources.groupToPrincipalGroupSearch = value;
        return (T)this;
    }

    public T groupToPrincipalGroupSearch(GroupToPrincipalGroupSearchConsumer consumer) {
        GroupToPrincipalGroupSearch child = new GroupToPrincipalGroupSearch();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.groupToPrincipalGroupSearch = child;
        return (T)this;
    }

    public T groupToPrincipalGroupSearch() {
        GroupToPrincipalGroupSearch child = new GroupToPrincipalGroupSearch();
        this.subresources.groupToPrincipalGroupSearch = child;
        return (T)this;
    }

    public T groupToPrincipalGroupSearch(GroupToPrincipalGroupSearchSupplier supplier) {
        this.subresources.groupToPrincipalGroupSearch = supplier.get();
        return (T)this;
    }

    public T advancedFilterUsernameToDn(AdvancedFilterUsernameToDn value) {
        this.subresources.advancedFilterUsernameToDn = value;
        return (T)this;
    }

    public T advancedFilterUsernameToDn(AdvancedFilterUsernameToDnConsumer consumer) {
        AdvancedFilterUsernameToDn child = new AdvancedFilterUsernameToDn();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.advancedFilterUsernameToDn = child;
        return (T)this;
    }

    public T advancedFilterUsernameToDn() {
        AdvancedFilterUsernameToDn child = new AdvancedFilterUsernameToDn();
        this.subresources.advancedFilterUsernameToDn = child;
        return (T)this;
    }

    public T advancedFilterUsernameToDn(AdvancedFilterUsernameToDnSupplier supplier) {
        this.subresources.advancedFilterUsernameToDn = supplier.get();
        return (T)this;
    }

    public T usernameIsDnUsernameToDn(UsernameIsDnUsernameToDn value) {
        this.subresources.usernameIsDnUsernameToDn = value;
        return (T)this;
    }

    public T usernameIsDnUsernameToDn(UsernameIsDnUsernameToDnConsumer consumer) {
        UsernameIsDnUsernameToDn child = new UsernameIsDnUsernameToDn();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.usernameIsDnUsernameToDn = child;
        return (T)this;
    }

    public T usernameIsDnUsernameToDn() {
        UsernameIsDnUsernameToDn child = new UsernameIsDnUsernameToDn();
        this.subresources.usernameIsDnUsernameToDn = child;
        return (T)this;
    }

    public T usernameIsDnUsernameToDn(UsernameIsDnUsernameToDnSupplier supplier) {
        this.subresources.usernameIsDnUsernameToDn = supplier.get();
        return (T)this;
    }

    public T principalToGroupGroupSearch(PrincipalToGroupGroupSearch value) {
        this.subresources.principalToGroupGroupSearch = value;
        return (T)this;
    }

    public T principalToGroupGroupSearch(PrincipalToGroupGroupSearchConsumer consumer) {
        PrincipalToGroupGroupSearch child = new PrincipalToGroupGroupSearch();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.principalToGroupGroupSearch = child;
        return (T)this;
    }

    public T principalToGroupGroupSearch() {
        PrincipalToGroupGroupSearch child = new PrincipalToGroupGroupSearch();
        this.subresources.principalToGroupGroupSearch = child;
        return (T)this;
    }

    public T principalToGroupGroupSearch(PrincipalToGroupGroupSearchSupplier supplier) {
        this.subresources.principalToGroupGroupSearch = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection")
    public String connection() {
        return this.connection;
    }

    public T connection(String value) {
        String oldValue = this.connection;
        this.connection = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connection", oldValue, value);
        }
        return (T)this;
    }

    public static class LdapAuthorizationResources {
        @SingletonResource
        @ResourceDocumentation(value="A simple filter configuration to identify the users distinguished name from their username.")
        private UsernameFilterUsernameToDn usernameFilterUsernameToDn;
        @SingletonResource
        @ResourceDocumentation(value="A group search where the group entry contains an attribute referencing it's members.")
        private GroupToPrincipalGroupSearch groupToPrincipalGroupSearch;
        @SingletonResource
        @ResourceDocumentation(value="An advanced filter configuration to identify the users distinguished name from the username.")
        private AdvancedFilterUsernameToDn advancedFilterUsernameToDn;
        @SingletonResource
        @ResourceDocumentation(value="User search configuration where the username is already a distinguished name.")
        private UsernameIsDnUsernameToDn usernameIsDnUsernameToDn;
        @SingletonResource
        @ResourceDocumentation(value="A group search where the principal entries contain an attribute referencing the groups that they are a member of.")
        private PrincipalToGroupGroupSearch principalToGroupGroupSearch;

        @Subresource
        public UsernameFilterUsernameToDn usernameFilterUsernameToDn() {
            return this.usernameFilterUsernameToDn;
        }

        @Subresource
        public GroupToPrincipalGroupSearch groupToPrincipalGroupSearch() {
            return this.groupToPrincipalGroupSearch;
        }

        @Subresource
        public AdvancedFilterUsernameToDn advancedFilterUsernameToDn() {
            return this.advancedFilterUsernameToDn;
        }

        @Subresource
        public UsernameIsDnUsernameToDn usernameIsDnUsernameToDn() {
            return this.usernameIsDnUsernameToDn;
        }

        @Subresource
        public PrincipalToGroupGroupSearch principalToGroupGroupSearch() {
            return this.principalToGroupGroupSearch;
        }
    }
}

