/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.security_realm.authorization;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.management.core.service.GroupName;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCache;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheSupplier;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCache;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/security-realm=*/authorization=ldap/group-search=principal-to-group")
@ResourceType(value="group-search")
@Implicit
public class PrincipalToGroupGroupSearch<T extends PrincipalToGroupGroupSearch<T>>
implements Keyed {
    private String key = "principal-to-group";
    private PropertyChangeSupport pcs;
    private PrincipalToGroupGroupSearchResources subresources = new PrincipalToGroupGroupSearchResources();
    @AttributeDocumentation(value="The attribute on the principal which references the group the principal is a member of.")
    private String groupAttribute;
    @AttributeDocumentation(value="Which attribute on a group entry is it's distinguished name.")
    private String groupDnAttribute;
    @AttributeDocumentation(value="An enumeration to identify if groups should be referenced using a simple name or their distinguished name.")
    private GroupName groupName;
    @AttributeDocumentation(value="Which attribute on a group entry is it's simple name.")
    private String groupNameAttribute;
    @AttributeDocumentation(value="Should further searches be performed to identify groups that the groups identified are a member of?")
    private Boolean iterative;
    @AttributeDocumentation(value="Should the group name be extracted from the distinguished name.")
    private Boolean parseGroupNameFromDn;
    @AttributeDocumentation(value="After following a referral should subsequent searches prefer the original connection or use the connection of the last referral.")
    private Boolean preferOriginalConnection;
    @AttributeDocumentation(value="If a non-existent group is referenced should it be quietly ignored.")
    private Boolean skipMissingGroups;

    public PrincipalToGroupGroupSearch() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public PrincipalToGroupGroupSearchResources subresources() {
        return this.subresources;
    }

    public T bySearchTimeCache(BySearchTimeCache value) {
        this.subresources.bySearchTimeCache = value;
        return (T)this;
    }

    public T bySearchTimeCache(BySearchTimeCacheConsumer consumer) {
        BySearchTimeCache child = new BySearchTimeCache();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.bySearchTimeCache = child;
        return (T)this;
    }

    public T bySearchTimeCache() {
        BySearchTimeCache child = new BySearchTimeCache();
        this.subresources.bySearchTimeCache = child;
        return (T)this;
    }

    public T bySearchTimeCache(BySearchTimeCacheSupplier supplier) {
        this.subresources.bySearchTimeCache = supplier.get();
        return (T)this;
    }

    public T byAccessTimeCache(ByAccessTimeCache value) {
        this.subresources.byAccessTimeCache = value;
        return (T)this;
    }

    public T byAccessTimeCache(ByAccessTimeCacheConsumer consumer) {
        ByAccessTimeCache child = new ByAccessTimeCache();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.byAccessTimeCache = child;
        return (T)this;
    }

    public T byAccessTimeCache() {
        ByAccessTimeCache child = new ByAccessTimeCache();
        this.subresources.byAccessTimeCache = child;
        return (T)this;
    }

    public T byAccessTimeCache(ByAccessTimeCacheSupplier supplier) {
        this.subresources.byAccessTimeCache = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="group-attribute")
    public String groupAttribute() {
        return this.groupAttribute;
    }

    public T groupAttribute(String value) {
        String oldValue = this.groupAttribute;
        this.groupAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("groupAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="group-dn-attribute")
    public String groupDnAttribute() {
        return this.groupDnAttribute;
    }

    public T groupDnAttribute(String value) {
        String oldValue = this.groupDnAttribute;
        this.groupDnAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("groupDnAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="group-name")
    public GroupName groupName() {
        return this.groupName;
    }

    public T groupName(GroupName value) {
        GroupName oldValue = this.groupName;
        this.groupName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("groupName", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="group-name-attribute")
    public String groupNameAttribute() {
        return this.groupNameAttribute;
    }

    public T groupNameAttribute(String value) {
        String oldValue = this.groupNameAttribute;
        this.groupNameAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("groupNameAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="iterative")
    public Boolean iterative() {
        return this.iterative;
    }

    public T iterative(Boolean value) {
        Boolean oldValue = this.iterative;
        this.iterative = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("iterative", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="parse-group-name-from-dn")
    public Boolean parseGroupNameFromDn() {
        return this.parseGroupNameFromDn;
    }

    public T parseGroupNameFromDn(Boolean value) {
        Boolean oldValue = this.parseGroupNameFromDn;
        this.parseGroupNameFromDn = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("parseGroupNameFromDn", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="prefer-original-connection")
    public Boolean preferOriginalConnection() {
        return this.preferOriginalConnection;
    }

    public T preferOriginalConnection(Boolean value) {
        Boolean oldValue = this.preferOriginalConnection;
        this.preferOriginalConnection = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preferOriginalConnection", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="skip-missing-groups")
    public Boolean skipMissingGroups() {
        return this.skipMissingGroups;
    }

    public T skipMissingGroups(Boolean value) {
        Boolean oldValue = this.skipMissingGroups;
        this.skipMissingGroups = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("skipMissingGroups", oldValue, value);
        }
        return (T)this;
    }

    public static class PrincipalToGroupGroupSearchResources {
        @SingletonResource
        @ResourceDocumentation(value="A cache to hold the results of previous LDAP interactions.")
        private BySearchTimeCache bySearchTimeCache;
        @SingletonResource
        @ResourceDocumentation(value="A cache to hold the results of previous LDAP interactions.")
        private ByAccessTimeCache byAccessTimeCache;

        @Subresource
        public BySearchTimeCache bySearchTimeCache() {
            return this.bySearchTimeCache;
        }

        @Subresource
        public ByAccessTimeCache byAccessTimeCache() {
            return this.byAccessTimeCache;
        }
    }
}

