/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.messaging.activemq.Connector;
import org.wildfly.swarm.config.messaging.activemq.ConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.ConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroup;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroupConsumer;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroupSupplier;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnector;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.InVMConnector;
import org.wildfly.swarm.config.messaging.activemq.InVMConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.InVMConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnector;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Acceptor;
import org.wildfly.swarm.config.messaging.activemq.server.AcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.AcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSetting;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSettingConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSettingSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Bridge;
import org.wildfly.swarm.config.messaging.activemq.server.BridgeConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BridgeSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroup;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroupConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroupSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnection;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnectionConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnectionSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorService;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorServiceConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorServiceSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddress;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddressConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddressSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Divert;
import org.wildfly.swarm.config.messaging.activemq.server.DivertConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.DivertSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandler;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandlerConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandlerSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueue;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopic;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopicConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopicSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Queue;
import org.wildfly.swarm.config.messaging.activemq.server.QueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.QueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueue;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySetting;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySettingConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySettingSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicySupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=messaging-activemq/server=*")
@ResourceType(value="server")
public class Server<T extends Server<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ServerResources subresources = new ServerResources();
    @AttributeDocumentation(value="Whether the server is active (and accepting connections) or passive (in backup mode, waiting for failover).")
    private Boolean active;
    @AttributeDocumentation(value="Whether incoming packets on the server should be handed off to a thread from the thread pool for processing. False if they should be handled on the remoting thread.")
    private Boolean asyncConnectionExecutionEnabled;
    @AttributeDocumentation(value="Credential (from Credential Store) to authenticate to cluster")
    private Map clusterCredentialReference;
    @AttributeDocumentation(value="The password used by cluster connections to communicate between the clustered nodes.")
    private String clusterPassword;
    @AttributeDocumentation(value="The user used by cluster connections to communicate between the clustered nodes.")
    private String clusterUser;
    @AttributeDocumentation(value="If set, this will override how long (in ms) to keep a connection alive without receiving a ping.")
    private Long connectionTtlOverride;
    @AttributeDocumentation(value="Whether the server should create the bindings directory on start up.")
    private Boolean createBindingsDir;
    @AttributeDocumentation(value="Whether the server should create the journal directory on start up.")
    private Boolean createJournalDir;
    @AttributeDocumentation(value="The name of the Elytron security domain used to verify user and role information.")
    private String elytronDomain;
    @AttributeDocumentation(value="The size of the cache for pre-creating message IDs.")
    private Integer idCacheSize;
    @AttributeDocumentation(value="The list of incoming interceptor classes used by this server.")
    private List<Map> incomingInterceptors;
    @AttributeDocumentation(value="The JMX domain used to register internal ActiveMQ MBeans in the MBeanServer.")
    private String jmxDomain;
    @AttributeDocumentation(value="Whether ActiveMQ should expose its internal management API via JMX. This is not recommended, as accessing these MBeans can lead to inconsistent configuration.")
    private Boolean jmxManagementEnabled;
    @AttributeDocumentation(value="Name of the JDBC table to store the bindings.")
    private String journalBindingsTable;
    @AttributeDocumentation(value="The size of the internal buffer on the journal.")
    private Long journalBufferSize;
    @AttributeDocumentation(value="The timeout (in nanoseconds) used to flush internal buffers on the journal.")
    private Long journalBufferTimeout;
    @AttributeDocumentation(value="The minimal number of journal data files before we can start compacting.")
    private Integer journalCompactMinFiles;
    @AttributeDocumentation(value="The percentage of live data on which we consider compacting the journal.")
    private Integer journalCompactPercentage;
    @AttributeDocumentation(value="Type of the database (can be used to customize SQL statements). If this attribute is not specified, the type of the database will be determined based on the DataSource metadata.")
    private String journalDatabase;
    @AttributeDocumentation(value="Name of the DataSource for the JDBC store.")
    private String journalDatasource;
    @AttributeDocumentation(value="The size (in bytes) of each journal file.")
    private Long journalFileSize;
    @AttributeDocumentation(value="The time the HA lock is considered valid without keeping it alive.")
    private Integer journalJdbcLockExpiration;
    @AttributeDocumentation(value="The renewal period for the HA lock to keep it alive.")
    private Integer journalJdbcLockRenewPeriod;
    @AttributeDocumentation(value="The timeout used by the JDBC connection to detect network issues.")
    private Integer journalJdbcNetworkTimeout;
    @AttributeDocumentation(value="Name of the JDBC table to store the large messages.")
    private String journalLargeMessagesTable;
    @AttributeDocumentation(value="The maximum number of write requests that can be in the AIO queue at any one time.")
    private Integer journalMaxIo;
    @AttributeDocumentation(value="Name of the JDBC table to store the messages.")
    private String journalMessagesTable;
    @AttributeDocumentation(value="How many journal files to pre-create.")
    private Integer journalMinFiles;
    @AttributeDocumentation(value="Name of the JDBC table to store the node manager.")
    private String journalNodeManagerStoreTable;
    @AttributeDocumentation(value="Name of the JDBC table to store pages.")
    private String journalPageStoreTable;
    @AttributeDocumentation(value="The number of journal files that can be reused. ActiveMQ will create as many files as needed however when reclaiming files it will shrink back to the value (-1 means no limit).")
    private Integer journalPoolFiles;
    @AttributeDocumentation(value="Whether to wait for non transaction data to be synced to the journal before returning a response to the client.")
    private Boolean journalSyncNonTransactional;
    @AttributeDocumentation(value="Whether to wait for transaction data to be synchronized to the journal before returning a response to the client.")
    private Boolean journalSyncTransactional;
    @AttributeDocumentation(value="The type of journal to use.")
    private JournalType journalType;
    @AttributeDocumentation(value="Whether to periodically log the journal's write rate and flush rate.")
    private Boolean logJournalWriteRate;
    @AttributeDocumentation(value="Address to send management messages to.")
    private String managementAddress;
    @AttributeDocumentation(value="The name of the address that consumers bind to  to receive management notifications.")
    private String managementNotificationAddress;
    @AttributeDocumentation(value="Frequency to sample JVM memory in ms (or -1 to disable memory sampling)")
    private Long memoryMeasureInterval;
    @AttributeDocumentation(value="Percentage of available memory which if exceeded results in a warning log")
    private Integer memoryWarningThreshold;
    @AttributeDocumentation(value="How many days to keep message counter history.")
    private Integer messageCounterMaxDayHistory;
    @AttributeDocumentation(value="The sample period (in ms) to use for message counters.")
    private Long messageCounterSamplePeriod;
    @AttributeDocumentation(value="How often (in ms) to scan for expired messages.")
    private Long messageExpiryScanPeriod;
    @AttributeDocumentation(value="The priority of the thread expiring messages.")
    private Integer messageExpiryThreadPriority;
    @AttributeDocumentation(value="The list of outgoing interceptor classes used by this server.")
    private List<Map> outgoingInterceptors;
    @AttributeDocumentation(value="Whether the ActiveMQ server will override security credentials for in-vm connections.")
    private Boolean overrideInVmSecurity;
    @AttributeDocumentation(value="The maximum number of concurrent reads allowed on paging")
    private Integer pageMaxConcurrentIo;
    @AttributeDocumentation(value="Whether the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.")
    private Boolean persistDeliveryCountBeforeDelivery;
    @AttributeDocumentation(value="Whether IDs are persisted to the journal.")
    private Boolean persistIdCache;
    @AttributeDocumentation(value="Whether the server will use the file based journal for persistence.")
    private Boolean persistenceEnabled;
    @AttributeDocumentation(value="The number of threads that the main scheduled thread pool has.")
    private Integer scheduledThreadPoolMaxSize;
    @AttributeDocumentation(value="Whether security is enabled.")
    private Boolean securityEnabled;
    @AttributeDocumentation(value="How long (in ms) to wait before invalidating the security cache.")
    private Long securityInvalidationInterval;
    @AttributeDocumentation(value="How often to dump basic runtime information to the server log. A value less than 1 disables this feature.")
    private Long serverDumpInterval;
    @AttributeDocumentation(value="Whether this server is started.")
    private Boolean started;
    @AttributeDocumentation(value="Whether gathering of statistics such as message counters are enabled.")
    private Boolean statisticsEnabled;
    @AttributeDocumentation(value="The number of threads that the main thread pool has. -1 means no limit.")
    private Integer threadPoolMaxSize;
    @AttributeDocumentation(value="How long (in ms) before a transaction can be removed from the resource manager after create time.")
    private Long transactionTimeout;
    @AttributeDocumentation(value="How often (in ms) to scan for timeout transactions.")
    private Long transactionTimeoutScanPeriod;
    @AttributeDocumentation(value="The server's version.")
    private String version;
    @AttributeDocumentation(value="Whether the server supports wild card routing.")
    private Boolean wildCardRoutingEnabled;

    public Server(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ServerResources subresources() {
        return this.subresources;
    }

    public T connectorServices(List<ConnectorService> value) {
        this.subresources.connectorServices = value;
        return (T)this;
    }

    public T connectorService(ConnectorService value) {
        this.subresources.connectorServices.add(value);
        return (T)this;
    }

    public T connectorService(String childKey, ConnectorServiceConsumer consumer) {
        ConnectorService child = new ConnectorService(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connectorService(child);
        return (T)this;
    }

    public T connectorService(String childKey) {
        this.connectorService(childKey, null);
        return (T)this;
    }

    public T connectorService(ConnectorServiceSupplier supplier) {
        this.connectorService(supplier.get());
        return (T)this;
    }

    public T httpAcceptors(List<HTTPAcceptor> value) {
        this.subresources.httpAcceptors = value;
        return (T)this;
    }

    public T httpAcceptor(HTTPAcceptor value) {
        this.subresources.httpAcceptors.add(value);
        return (T)this;
    }

    public T httpAcceptor(String childKey, HTTPAcceptorConsumer consumer) {
        HTTPAcceptor child = new HTTPAcceptor(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.httpAcceptor(child);
        return (T)this;
    }

    public T httpAcceptor(String childKey) {
        this.httpAcceptor(childKey, null);
        return (T)this;
    }

    public T httpAcceptor(HTTPAcceptorSupplier supplier) {
        this.httpAcceptor(supplier.get());
        return (T)this;
    }

    public T clusterConnections(List<ClusterConnection> value) {
        this.subresources.clusterConnections = value;
        return (T)this;
    }

    public T clusterConnection(ClusterConnection value) {
        this.subresources.clusterConnections.add(value);
        return (T)this;
    }

    public T clusterConnection(String childKey, ClusterConnectionConsumer consumer) {
        ClusterConnection child = new ClusterConnection(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.clusterConnection(child);
        return (T)this;
    }

    public T clusterConnection(String childKey) {
        this.clusterConnection(childKey, null);
        return (T)this;
    }

    public T clusterConnection(ClusterConnectionSupplier supplier) {
        this.clusterConnection(supplier.get());
        return (T)this;
    }

    public T broadcastGroups(List<BroadcastGroup> value) {
        this.subresources.broadcastGroups = value;
        return (T)this;
    }

    public T broadcastGroup(BroadcastGroup value) {
        this.subresources.broadcastGroups.add(value);
        return (T)this;
    }

    public T broadcastGroup(String childKey, BroadcastGroupConsumer consumer) {
        BroadcastGroup child = new BroadcastGroup(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.broadcastGroup(child);
        return (T)this;
    }

    public T broadcastGroup(String childKey) {
        this.broadcastGroup(childKey, null);
        return (T)this;
    }

    public T broadcastGroup(BroadcastGroupSupplier supplier) {
        this.broadcastGroup(supplier.get());
        return (T)this;
    }

    public T runtimeQueues(List<RuntimeQueue> value) {
        this.subresources.runtimeQueues = value;
        return (T)this;
    }

    public T runtimeQueue(RuntimeQueue value) {
        this.subresources.runtimeQueues.add(value);
        return (T)this;
    }

    public T runtimeQueue(String childKey, RuntimeQueueConsumer consumer) {
        RuntimeQueue child = new RuntimeQueue(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.runtimeQueue(child);
        return (T)this;
    }

    public T runtimeQueue(String childKey) {
        this.runtimeQueue(childKey, null);
        return (T)this;
    }

    public T runtimeQueue(RuntimeQueueSupplier supplier) {
        this.runtimeQueue(supplier.get());
        return (T)this;
    }

    public T addressSettings(List<AddressSetting> value) {
        this.subresources.addressSettings = value;
        return (T)this;
    }

    public T addressSetting(AddressSetting value) {
        this.subresources.addressSettings.add(value);
        return (T)this;
    }

    public T addressSetting(String childKey, AddressSettingConsumer consumer) {
        AddressSetting child = new AddressSetting(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.addressSetting(child);
        return (T)this;
    }

    public T addressSetting(String childKey) {
        this.addressSetting(childKey, null);
        return (T)this;
    }

    public T addressSetting(AddressSettingSupplier supplier) {
        this.addressSetting(supplier.get());
        return (T)this;
    }

    public T jmsQueues(List<JMSQueue> value) {
        this.subresources.jmsQueues = value;
        return (T)this;
    }

    public T jmsQueue(JMSQueue value) {
        this.subresources.jmsQueues.add(value);
        return (T)this;
    }

    public T jmsQueue(String childKey, JMSQueueConsumer consumer) {
        JMSQueue child = new JMSQueue(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jmsQueue(child);
        return (T)this;
    }

    public T jmsQueue(String childKey) {
        this.jmsQueue(childKey, null);
        return (T)this;
    }

    public T jmsQueue(JMSQueueSupplier supplier) {
        this.jmsQueue(supplier.get());
        return (T)this;
    }

    public T pooledConnectionFactories(List<PooledConnectionFactory> value) {
        this.subresources.pooledConnectionFactories = value;
        return (T)this;
    }

    public T pooledConnectionFactory(PooledConnectionFactory value) {
        this.subresources.pooledConnectionFactories.add(value);
        return (T)this;
    }

    public T pooledConnectionFactory(String childKey, PooledConnectionFactoryConsumer consumer) {
        PooledConnectionFactory child = new PooledConnectionFactory(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.pooledConnectionFactory(child);
        return (T)this;
    }

    public T pooledConnectionFactory(String childKey) {
        this.pooledConnectionFactory(childKey, null);
        return (T)this;
    }

    public T pooledConnectionFactory(PooledConnectionFactorySupplier supplier) {
        this.pooledConnectionFactory(supplier.get());
        return (T)this;
    }

    public T diverts(List<Divert> value) {
        this.subresources.diverts = value;
        return (T)this;
    }

    public T divert(Divert value) {
        this.subresources.diverts.add(value);
        return (T)this;
    }

    public T divert(String childKey, DivertConsumer consumer) {
        Divert child = new Divert(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.divert(child);
        return (T)this;
    }

    public T divert(String childKey) {
        this.divert(childKey, null);
        return (T)this;
    }

    public T divert(DivertSupplier supplier) {
        this.divert(supplier.get());
        return (T)this;
    }

    public T inVmAcceptors(List<InVMAcceptor> value) {
        this.subresources.inVmAcceptors = value;
        return (T)this;
    }

    public T inVmAcceptor(InVMAcceptor value) {
        this.subresources.inVmAcceptors.add(value);
        return (T)this;
    }

    public T inVmAcceptor(String childKey, InVMAcceptorConsumer consumer) {
        InVMAcceptor child = new InVMAcceptor(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.inVmAcceptor(child);
        return (T)this;
    }

    public T inVmAcceptor(String childKey) {
        this.inVmAcceptor(childKey, null);
        return (T)this;
    }

    public T inVmAcceptor(InVMAcceptorSupplier supplier) {
        this.inVmAcceptor(supplier.get());
        return (T)this;
    }

    public T discoveryGroups(List<DiscoveryGroup> value) {
        this.subresources.discoveryGroups = value;
        return (T)this;
    }

    public T discoveryGroup(DiscoveryGroup value) {
        this.subresources.discoveryGroups.add(value);
        return (T)this;
    }

    public T discoveryGroup(String childKey, DiscoveryGroupConsumer consumer) {
        DiscoveryGroup child = new DiscoveryGroup(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.discoveryGroup(child);
        return (T)this;
    }

    public T discoveryGroup(String childKey) {
        this.discoveryGroup(childKey, null);
        return (T)this;
    }

    public T discoveryGroup(DiscoveryGroupSupplier supplier) {
        this.discoveryGroup(supplier.get());
        return (T)this;
    }

    public T httpConnectors(List<HTTPConnector> value) {
        this.subresources.httpConnectors = value;
        return (T)this;
    }

    public T httpConnector(HTTPConnector value) {
        this.subresources.httpConnectors.add(value);
        return (T)this;
    }

    public T httpConnector(String childKey, HTTPConnectorConsumer consumer) {
        HTTPConnector child = new HTTPConnector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.httpConnector(child);
        return (T)this;
    }

    public T httpConnector(String childKey) {
        this.httpConnector(childKey, null);
        return (T)this;
    }

    public T httpConnector(HTTPConnectorSupplier supplier) {
        this.httpConnector(supplier.get());
        return (T)this;
    }

    public T connectionFactories(List<ConnectionFactory> value) {
        this.subresources.connectionFactories = value;
        return (T)this;
    }

    public T connectionFactory(ConnectionFactory value) {
        this.subresources.connectionFactories.add(value);
        return (T)this;
    }

    public T connectionFactory(String childKey, ConnectionFactoryConsumer consumer) {
        ConnectionFactory child = new ConnectionFactory(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connectionFactory(child);
        return (T)this;
    }

    public T connectionFactory(String childKey) {
        this.connectionFactory(childKey, null);
        return (T)this;
    }

    public T connectionFactory(ConnectionFactorySupplier supplier) {
        this.connectionFactory(supplier.get());
        return (T)this;
    }

    public T acceptors(List<Acceptor> value) {
        this.subresources.acceptors = value;
        return (T)this;
    }

    public T acceptor(Acceptor value) {
        this.subresources.acceptors.add(value);
        return (T)this;
    }

    public T acceptor(String childKey, AcceptorConsumer consumer) {
        Acceptor child = new Acceptor(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.acceptor(child);
        return (T)this;
    }

    public T acceptor(String childKey) {
        this.acceptor(childKey, null);
        return (T)this;
    }

    public T acceptor(AcceptorSupplier supplier) {
        this.acceptor(supplier.get());
        return (T)this;
    }

    public T remoteAcceptors(List<RemoteAcceptor> value) {
        this.subresources.remoteAcceptors = value;
        return (T)this;
    }

    public T remoteAcceptor(RemoteAcceptor value) {
        this.subresources.remoteAcceptors.add(value);
        return (T)this;
    }

    public T remoteAcceptor(String childKey, RemoteAcceptorConsumer consumer) {
        RemoteAcceptor child = new RemoteAcceptor(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remoteAcceptor(child);
        return (T)this;
    }

    public T remoteAcceptor(String childKey) {
        this.remoteAcceptor(childKey, null);
        return (T)this;
    }

    public T remoteAcceptor(RemoteAcceptorSupplier supplier) {
        this.remoteAcceptor(supplier.get());
        return (T)this;
    }

    public T remoteConnectors(List<RemoteConnector> value) {
        this.subresources.remoteConnectors = value;
        return (T)this;
    }

    public T remoteConnector(RemoteConnector value) {
        this.subresources.remoteConnectors.add(value);
        return (T)this;
    }

    public T remoteConnector(String childKey, RemoteConnectorConsumer consumer) {
        RemoteConnector child = new RemoteConnector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remoteConnector(child);
        return (T)this;
    }

    public T remoteConnector(String childKey) {
        this.remoteConnector(childKey, null);
        return (T)this;
    }

    public T remoteConnector(RemoteConnectorSupplier supplier) {
        this.remoteConnector(supplier.get());
        return (T)this;
    }

    public T inVmConnectors(List<InVMConnector> value) {
        this.subresources.inVmConnectors = value;
        return (T)this;
    }

    public T inVmConnector(InVMConnector value) {
        this.subresources.inVmConnectors.add(value);
        return (T)this;
    }

    public T inVmConnector(String childKey, InVMConnectorConsumer consumer) {
        InVMConnector child = new InVMConnector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.inVmConnector(child);
        return (T)this;
    }

    public T inVmConnector(String childKey) {
        this.inVmConnector(childKey, null);
        return (T)this;
    }

    public T inVmConnector(InVMConnectorSupplier supplier) {
        this.inVmConnector(supplier.get());
        return (T)this;
    }

    public T legacyConnectionFactories(List<LegacyConnectionFactory> value) {
        this.subresources.legacyConnectionFactories = value;
        return (T)this;
    }

    public T legacyConnectionFactory(LegacyConnectionFactory value) {
        this.subresources.legacyConnectionFactories.add(value);
        return (T)this;
    }

    public T legacyConnectionFactory(String childKey, LegacyConnectionFactoryConsumer consumer) {
        LegacyConnectionFactory child = new LegacyConnectionFactory(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.legacyConnectionFactory(child);
        return (T)this;
    }

    public T legacyConnectionFactory(String childKey) {
        this.legacyConnectionFactory(childKey, null);
        return (T)this;
    }

    public T legacyConnectionFactory(LegacyConnectionFactorySupplier supplier) {
        this.legacyConnectionFactory(supplier.get());
        return (T)this;
    }

    public T groupingHandlers(List<GroupingHandler> value) {
        this.subresources.groupingHandlers = value;
        return (T)this;
    }

    public T groupingHandler(GroupingHandler value) {
        this.subresources.groupingHandlers.add(value);
        return (T)this;
    }

    public T groupingHandler(String childKey, GroupingHandlerConsumer consumer) {
        GroupingHandler child = new GroupingHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.groupingHandler(child);
        return (T)this;
    }

    public T groupingHandler(String childKey) {
        this.groupingHandler(childKey, null);
        return (T)this;
    }

    public T groupingHandler(GroupingHandlerSupplier supplier) {
        this.groupingHandler(supplier.get());
        return (T)this;
    }

    public T jmsTopics(List<JMSTopic> value) {
        this.subresources.jmsTopics = value;
        return (T)this;
    }

    public T jmsTopic(JMSTopic value) {
        this.subresources.jmsTopics.add(value);
        return (T)this;
    }

    public T jmsTopic(String childKey, JMSTopicConsumer consumer) {
        JMSTopic child = new JMSTopic(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jmsTopic(child);
        return (T)this;
    }

    public T jmsTopic(String childKey) {
        this.jmsTopic(childKey, null);
        return (T)this;
    }

    public T jmsTopic(JMSTopicSupplier supplier) {
        this.jmsTopic(supplier.get());
        return (T)this;
    }

    public T connectors(List<Connector> value) {
        this.subresources.connectors = value;
        return (T)this;
    }

    public T connector(Connector value) {
        this.subresources.connectors.add(value);
        return (T)this;
    }

    public T connector(String childKey, ConnectorConsumer consumer) {
        Connector child = new Connector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connector(child);
        return (T)this;
    }

    public T connector(String childKey) {
        this.connector(childKey, null);
        return (T)this;
    }

    public T connector(ConnectorSupplier supplier) {
        this.connector(supplier.get());
        return (T)this;
    }

    public T securitySettings(List<SecuritySetting> value) {
        this.subresources.securitySettings = value;
        return (T)this;
    }

    public T securitySetting(SecuritySetting value) {
        this.subresources.securitySettings.add(value);
        return (T)this;
    }

    public T securitySetting(String childKey, SecuritySettingConsumer consumer) {
        SecuritySetting child = new SecuritySetting(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.securitySetting(child);
        return (T)this;
    }

    public T securitySetting(String childKey) {
        this.securitySetting(childKey, null);
        return (T)this;
    }

    public T securitySetting(SecuritySettingSupplier supplier) {
        this.securitySetting(supplier.get());
        return (T)this;
    }

    public T coreAddress(List<CoreAddress> value) {
        this.subresources.coreAddress = value;
        return (T)this;
    }

    public T coreAddress(CoreAddress value) {
        this.subresources.coreAddress.add(value);
        return (T)this;
    }

    public T coreAddress(String childKey, CoreAddressConsumer consumer) {
        CoreAddress child = new CoreAddress(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.coreAddress(child);
        return (T)this;
    }

    public T coreAddress(String childKey) {
        this.coreAddress(childKey, null);
        return (T)this;
    }

    public T coreAddress(CoreAddressSupplier supplier) {
        this.coreAddress(supplier.get());
        return (T)this;
    }

    public T bridges(List<Bridge> value) {
        this.subresources.bridges = value;
        return (T)this;
    }

    public T bridge(Bridge value) {
        this.subresources.bridges.add(value);
        return (T)this;
    }

    public T bridge(String childKey, BridgeConsumer consumer) {
        Bridge child = new Bridge(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.bridge(child);
        return (T)this;
    }

    public T bridge(String childKey) {
        this.bridge(childKey, null);
        return (T)this;
    }

    public T bridge(BridgeSupplier supplier) {
        this.bridge(supplier.get());
        return (T)this;
    }

    public T queues(List<Queue> value) {
        this.subresources.queues = value;
        return (T)this;
    }

    public T queue(Queue value) {
        this.subresources.queues.add(value);
        return (T)this;
    }

    public T queue(String childKey, QueueConsumer consumer) {
        Queue child = new Queue(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.queue(child);
        return (T)this;
    }

    public T queue(String childKey) {
        this.queue(childKey, null);
        return (T)this;
    }

    public T queue(QueueSupplier supplier) {
        this.queue(supplier.get());
        return (T)this;
    }

    public T sharedStoreColocatedHaPolicy(SharedStoreColocatedHAPolicy value) {
        this.subresources.sharedStoreColocatedHaPolicy = value;
        return (T)this;
    }

    public T sharedStoreColocatedHaPolicy(SharedStoreColocatedHAPolicyConsumer consumer) {
        SharedStoreColocatedHAPolicy child = new SharedStoreColocatedHAPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.sharedStoreColocatedHaPolicy = child;
        return (T)this;
    }

    public T sharedStoreColocatedHaPolicy() {
        SharedStoreColocatedHAPolicy child = new SharedStoreColocatedHAPolicy();
        this.subresources.sharedStoreColocatedHaPolicy = child;
        return (T)this;
    }

    public T sharedStoreColocatedHaPolicy(SharedStoreColocatedHAPolicySupplier supplier) {
        this.subresources.sharedStoreColocatedHaPolicy = supplier.get();
        return (T)this;
    }

    public T replicationMasterHaPolicy(ReplicationMasterHAPolicy value) {
        this.subresources.replicationMasterHaPolicy = value;
        return (T)this;
    }

    public T replicationMasterHaPolicy(ReplicationMasterHAPolicyConsumer consumer) {
        ReplicationMasterHAPolicy child = new ReplicationMasterHAPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.replicationMasterHaPolicy = child;
        return (T)this;
    }

    public T replicationMasterHaPolicy() {
        ReplicationMasterHAPolicy child = new ReplicationMasterHAPolicy();
        this.subresources.replicationMasterHaPolicy = child;
        return (T)this;
    }

    public T replicationMasterHaPolicy(ReplicationMasterHAPolicySupplier supplier) {
        this.subresources.replicationMasterHaPolicy = supplier.get();
        return (T)this;
    }

    public T sharedStoreMasterHaPolicy(SharedStoreMasterHAPolicy value) {
        this.subresources.sharedStoreMasterHaPolicy = value;
        return (T)this;
    }

    public T sharedStoreMasterHaPolicy(SharedStoreMasterHAPolicyConsumer consumer) {
        SharedStoreMasterHAPolicy child = new SharedStoreMasterHAPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.sharedStoreMasterHaPolicy = child;
        return (T)this;
    }

    public T sharedStoreMasterHaPolicy() {
        SharedStoreMasterHAPolicy child = new SharedStoreMasterHAPolicy();
        this.subresources.sharedStoreMasterHaPolicy = child;
        return (T)this;
    }

    public T sharedStoreMasterHaPolicy(SharedStoreMasterHAPolicySupplier supplier) {
        this.subresources.sharedStoreMasterHaPolicy = supplier.get();
        return (T)this;
    }

    public T bindingsDirectoryPath(BindingsDirectoryPath value) {
        this.subresources.bindingsDirectoryPath = value;
        return (T)this;
    }

    public T bindingsDirectoryPath(BindingsDirectoryPathConsumer consumer) {
        BindingsDirectoryPath child = new BindingsDirectoryPath();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.bindingsDirectoryPath = child;
        return (T)this;
    }

    public T bindingsDirectoryPath() {
        BindingsDirectoryPath child = new BindingsDirectoryPath();
        this.subresources.bindingsDirectoryPath = child;
        return (T)this;
    }

    public T bindingsDirectoryPath(BindingsDirectoryPathSupplier supplier) {
        this.subresources.bindingsDirectoryPath = supplier.get();
        return (T)this;
    }

    public T replicationColocatedHaPolicy(ReplicationColocatedHAPolicy value) {
        this.subresources.replicationColocatedHaPolicy = value;
        return (T)this;
    }

    public T replicationColocatedHaPolicy(ReplicationColocatedHAPolicyConsumer consumer) {
        ReplicationColocatedHAPolicy child = new ReplicationColocatedHAPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.replicationColocatedHaPolicy = child;
        return (T)this;
    }

    public T replicationColocatedHaPolicy() {
        ReplicationColocatedHAPolicy child = new ReplicationColocatedHAPolicy();
        this.subresources.replicationColocatedHaPolicy = child;
        return (T)this;
    }

    public T replicationColocatedHaPolicy(ReplicationColocatedHAPolicySupplier supplier) {
        this.subresources.replicationColocatedHaPolicy = supplier.get();
        return (T)this;
    }

    public T journalDirectoryPath(JournalDirectoryPath value) {
        this.subresources.journalDirectoryPath = value;
        return (T)this;
    }

    public T journalDirectoryPath(JournalDirectoryPathConsumer consumer) {
        JournalDirectoryPath child = new JournalDirectoryPath();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.journalDirectoryPath = child;
        return (T)this;
    }

    public T journalDirectoryPath() {
        JournalDirectoryPath child = new JournalDirectoryPath();
        this.subresources.journalDirectoryPath = child;
        return (T)this;
    }

    public T journalDirectoryPath(JournalDirectoryPathSupplier supplier) {
        this.subresources.journalDirectoryPath = supplier.get();
        return (T)this;
    }

    public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicy value) {
        this.subresources.sharedStoreSlaveHaPolicy = value;
        return (T)this;
    }

    public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicyConsumer consumer) {
        SharedStoreSlaveHAPolicy child = new SharedStoreSlaveHAPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.sharedStoreSlaveHaPolicy = child;
        return (T)this;
    }

    public T sharedStoreSlaveHaPolicy() {
        SharedStoreSlaveHAPolicy child = new SharedStoreSlaveHAPolicy();
        this.subresources.sharedStoreSlaveHaPolicy = child;
        return (T)this;
    }

    public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicySupplier supplier) {
        this.subresources.sharedStoreSlaveHaPolicy = supplier.get();
        return (T)this;
    }

    public T pagingDirectoryPath(PagingDirectoryPath value) {
        this.subresources.pagingDirectoryPath = value;
        return (T)this;
    }

    public T pagingDirectoryPath(PagingDirectoryPathConsumer consumer) {
        PagingDirectoryPath child = new PagingDirectoryPath();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.pagingDirectoryPath = child;
        return (T)this;
    }

    public T pagingDirectoryPath() {
        PagingDirectoryPath child = new PagingDirectoryPath();
        this.subresources.pagingDirectoryPath = child;
        return (T)this;
    }

    public T pagingDirectoryPath(PagingDirectoryPathSupplier supplier) {
        this.subresources.pagingDirectoryPath = supplier.get();
        return (T)this;
    }

    public T largeMessagesDirectoryPath(LargeMessagesDirectoryPath value) {
        this.subresources.largeMessagesDirectoryPath = value;
        return (T)this;
    }

    public T largeMessagesDirectoryPath(LargeMessagesDirectoryPathConsumer consumer) {
        LargeMessagesDirectoryPath child = new LargeMessagesDirectoryPath();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.largeMessagesDirectoryPath = child;
        return (T)this;
    }

    public T largeMessagesDirectoryPath() {
        LargeMessagesDirectoryPath child = new LargeMessagesDirectoryPath();
        this.subresources.largeMessagesDirectoryPath = child;
        return (T)this;
    }

    public T largeMessagesDirectoryPath(LargeMessagesDirectoryPathSupplier supplier) {
        this.subresources.largeMessagesDirectoryPath = supplier.get();
        return (T)this;
    }

    public T liveOnlyHaPolicy(LiveOnlyHAPolicy value) {
        this.subresources.liveOnlyHaPolicy = value;
        return (T)this;
    }

    public T liveOnlyHaPolicy(LiveOnlyHAPolicyConsumer consumer) {
        LiveOnlyHAPolicy child = new LiveOnlyHAPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.liveOnlyHaPolicy = child;
        return (T)this;
    }

    public T liveOnlyHaPolicy() {
        LiveOnlyHAPolicy child = new LiveOnlyHAPolicy();
        this.subresources.liveOnlyHaPolicy = child;
        return (T)this;
    }

    public T liveOnlyHaPolicy(LiveOnlyHAPolicySupplier supplier) {
        this.subresources.liveOnlyHaPolicy = supplier.get();
        return (T)this;
    }

    public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicy value) {
        this.subresources.replicationSlaveHaPolicy = value;
        return (T)this;
    }

    public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicyConsumer consumer) {
        ReplicationSlaveHAPolicy child = new ReplicationSlaveHAPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.replicationSlaveHaPolicy = child;
        return (T)this;
    }

    public T replicationSlaveHaPolicy() {
        ReplicationSlaveHAPolicy child = new ReplicationSlaveHAPolicy();
        this.subresources.replicationSlaveHaPolicy = child;
        return (T)this;
    }

    public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicySupplier supplier) {
        this.subresources.replicationSlaveHaPolicy = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="active")
    public Boolean active() {
        return this.active;
    }

    public T active(Boolean value) {
        Boolean oldValue = this.active;
        this.active = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("active", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="async-connection-execution-enabled")
    public Boolean asyncConnectionExecutionEnabled() {
        return this.asyncConnectionExecutionEnabled;
    }

    public T asyncConnectionExecutionEnabled(Boolean value) {
        Boolean oldValue = this.asyncConnectionExecutionEnabled;
        this.asyncConnectionExecutionEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("asyncConnectionExecutionEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cluster-credential-reference")
    public Map clusterCredentialReference() {
        return this.clusterCredentialReference;
    }

    public T clusterCredentialReference(Map value) {
        Map oldValue = this.clusterCredentialReference;
        this.clusterCredentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clusterCredentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T clusterCredentialReference(String key, Object value) {
        if (this.clusterCredentialReference == null) {
            this.clusterCredentialReference = new HashMap();
        }
        this.clusterCredentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cluster-password")
    public String clusterPassword() {
        return this.clusterPassword;
    }

    public T clusterPassword(String value) {
        String oldValue = this.clusterPassword;
        this.clusterPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clusterPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cluster-user")
    public String clusterUser() {
        return this.clusterUser;
    }

    public T clusterUser(String value) {
        String oldValue = this.clusterUser;
        this.clusterUser = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clusterUser", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-ttl-override")
    public Long connectionTtlOverride() {
        return this.connectionTtlOverride;
    }

    public T connectionTtlOverride(Long value) {
        Long oldValue = this.connectionTtlOverride;
        this.connectionTtlOverride = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionTtlOverride", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="create-bindings-dir")
    public Boolean createBindingsDir() {
        return this.createBindingsDir;
    }

    public T createBindingsDir(Boolean value) {
        Boolean oldValue = this.createBindingsDir;
        this.createBindingsDir = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("createBindingsDir", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="create-journal-dir")
    public Boolean createJournalDir() {
        return this.createJournalDir;
    }

    public T createJournalDir(Boolean value) {
        Boolean oldValue = this.createJournalDir;
        this.createJournalDir = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("createJournalDir", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="elytron-domain")
    public String elytronDomain() {
        return this.elytronDomain;
    }

    public T elytronDomain(String value) {
        String oldValue = this.elytronDomain;
        this.elytronDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("elytronDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="id-cache-size")
    public Integer idCacheSize() {
        return this.idCacheSize;
    }

    public T idCacheSize(Integer value) {
        Integer oldValue = this.idCacheSize;
        this.idCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("idCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="incoming-interceptors")
    public List<Map> incomingInterceptors() {
        return this.incomingInterceptors;
    }

    public T incomingInterceptors(List<Map> value) {
        List<Map> oldValue = this.incomingInterceptors;
        this.incomingInterceptors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("incomingInterceptors", oldValue, value);
        }
        return (T)this;
    }

    public T incomingInterceptor(Map value) {
        if (this.incomingInterceptors == null) {
            this.incomingInterceptors = new ArrayList<Map>();
        }
        this.incomingInterceptors.add(value);
        return (T)this;
    }

    public T incomingInterceptors(Map ... args) {
        this.incomingInterceptors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jmx-domain")
    public String jmxDomain() {
        return this.jmxDomain;
    }

    public T jmxDomain(String value) {
        String oldValue = this.jmxDomain;
        this.jmxDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jmxDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jmx-management-enabled")
    public Boolean jmxManagementEnabled() {
        return this.jmxManagementEnabled;
    }

    public T jmxManagementEnabled(Boolean value) {
        Boolean oldValue = this.jmxManagementEnabled;
        this.jmxManagementEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jmxManagementEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-bindings-table")
    public String journalBindingsTable() {
        return this.journalBindingsTable;
    }

    public T journalBindingsTable(String value) {
        String oldValue = this.journalBindingsTable;
        this.journalBindingsTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalBindingsTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-buffer-size")
    public Long journalBufferSize() {
        return this.journalBufferSize;
    }

    public T journalBufferSize(Long value) {
        Long oldValue = this.journalBufferSize;
        this.journalBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-buffer-timeout")
    public Long journalBufferTimeout() {
        return this.journalBufferTimeout;
    }

    public T journalBufferTimeout(Long value) {
        Long oldValue = this.journalBufferTimeout;
        this.journalBufferTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalBufferTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-compact-min-files")
    public Integer journalCompactMinFiles() {
        return this.journalCompactMinFiles;
    }

    public T journalCompactMinFiles(Integer value) {
        Integer oldValue = this.journalCompactMinFiles;
        this.journalCompactMinFiles = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalCompactMinFiles", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-compact-percentage")
    public Integer journalCompactPercentage() {
        return this.journalCompactPercentage;
    }

    public T journalCompactPercentage(Integer value) {
        Integer oldValue = this.journalCompactPercentage;
        this.journalCompactPercentage = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalCompactPercentage", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-database")
    public String journalDatabase() {
        return this.journalDatabase;
    }

    public T journalDatabase(String value) {
        String oldValue = this.journalDatabase;
        this.journalDatabase = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalDatabase", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-datasource")
    public String journalDatasource() {
        return this.journalDatasource;
    }

    public T journalDatasource(String value) {
        String oldValue = this.journalDatasource;
        this.journalDatasource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalDatasource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-file-size")
    public Long journalFileSize() {
        return this.journalFileSize;
    }

    public T journalFileSize(Long value) {
        Long oldValue = this.journalFileSize;
        this.journalFileSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalFileSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-jdbc-lock-expiration")
    public Integer journalJdbcLockExpiration() {
        return this.journalJdbcLockExpiration;
    }

    public T journalJdbcLockExpiration(Integer value) {
        Integer oldValue = this.journalJdbcLockExpiration;
        this.journalJdbcLockExpiration = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalJdbcLockExpiration", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-jdbc-lock-renew-period")
    public Integer journalJdbcLockRenewPeriod() {
        return this.journalJdbcLockRenewPeriod;
    }

    public T journalJdbcLockRenewPeriod(Integer value) {
        Integer oldValue = this.journalJdbcLockRenewPeriod;
        this.journalJdbcLockRenewPeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalJdbcLockRenewPeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-jdbc-network-timeout")
    public Integer journalJdbcNetworkTimeout() {
        return this.journalJdbcNetworkTimeout;
    }

    public T journalJdbcNetworkTimeout(Integer value) {
        Integer oldValue = this.journalJdbcNetworkTimeout;
        this.journalJdbcNetworkTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalJdbcNetworkTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-large-messages-table")
    public String journalLargeMessagesTable() {
        return this.journalLargeMessagesTable;
    }

    public T journalLargeMessagesTable(String value) {
        String oldValue = this.journalLargeMessagesTable;
        this.journalLargeMessagesTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalLargeMessagesTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-max-io")
    public Integer journalMaxIo() {
        return this.journalMaxIo;
    }

    public T journalMaxIo(Integer value) {
        Integer oldValue = this.journalMaxIo;
        this.journalMaxIo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalMaxIo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-messages-table")
    public String journalMessagesTable() {
        return this.journalMessagesTable;
    }

    public T journalMessagesTable(String value) {
        String oldValue = this.journalMessagesTable;
        this.journalMessagesTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalMessagesTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-min-files")
    public Integer journalMinFiles() {
        return this.journalMinFiles;
    }

    public T journalMinFiles(Integer value) {
        Integer oldValue = this.journalMinFiles;
        this.journalMinFiles = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalMinFiles", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-node-manager-store-table")
    public String journalNodeManagerStoreTable() {
        return this.journalNodeManagerStoreTable;
    }

    public T journalNodeManagerStoreTable(String value) {
        String oldValue = this.journalNodeManagerStoreTable;
        this.journalNodeManagerStoreTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalNodeManagerStoreTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-page-store-table")
    public String journalPageStoreTable() {
        return this.journalPageStoreTable;
    }

    public T journalPageStoreTable(String value) {
        String oldValue = this.journalPageStoreTable;
        this.journalPageStoreTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalPageStoreTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-pool-files")
    public Integer journalPoolFiles() {
        return this.journalPoolFiles;
    }

    public T journalPoolFiles(Integer value) {
        Integer oldValue = this.journalPoolFiles;
        this.journalPoolFiles = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalPoolFiles", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-sync-non-transactional")
    public Boolean journalSyncNonTransactional() {
        return this.journalSyncNonTransactional;
    }

    public T journalSyncNonTransactional(Boolean value) {
        Boolean oldValue = this.journalSyncNonTransactional;
        this.journalSyncNonTransactional = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalSyncNonTransactional", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-sync-transactional")
    public Boolean journalSyncTransactional() {
        return this.journalSyncTransactional;
    }

    public T journalSyncTransactional(Boolean value) {
        Boolean oldValue = this.journalSyncTransactional;
        this.journalSyncTransactional = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalSyncTransactional", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-type")
    public JournalType journalType() {
        return this.journalType;
    }

    public T journalType(JournalType value) {
        JournalType oldValue = this.journalType;
        this.journalType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="log-journal-write-rate")
    public Boolean logJournalWriteRate() {
        return this.logJournalWriteRate;
    }

    public T logJournalWriteRate(Boolean value) {
        Boolean oldValue = this.logJournalWriteRate;
        this.logJournalWriteRate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("logJournalWriteRate", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="management-address")
    public String managementAddress() {
        return this.managementAddress;
    }

    public T managementAddress(String value) {
        String oldValue = this.managementAddress;
        this.managementAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("managementAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="management-notification-address")
    public String managementNotificationAddress() {
        return this.managementNotificationAddress;
    }

    public T managementNotificationAddress(String value) {
        String oldValue = this.managementNotificationAddress;
        this.managementNotificationAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("managementNotificationAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="memory-measure-interval")
    public Long memoryMeasureInterval() {
        return this.memoryMeasureInterval;
    }

    public T memoryMeasureInterval(Long value) {
        Long oldValue = this.memoryMeasureInterval;
        this.memoryMeasureInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("memoryMeasureInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="memory-warning-threshold")
    public Integer memoryWarningThreshold() {
        return this.memoryWarningThreshold;
    }

    public T memoryWarningThreshold(Integer value) {
        Integer oldValue = this.memoryWarningThreshold;
        this.memoryWarningThreshold = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("memoryWarningThreshold", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-counter-max-day-history")
    public Integer messageCounterMaxDayHistory() {
        return this.messageCounterMaxDayHistory;
    }

    public T messageCounterMaxDayHistory(Integer value) {
        Integer oldValue = this.messageCounterMaxDayHistory;
        this.messageCounterMaxDayHistory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageCounterMaxDayHistory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-counter-sample-period")
    public Long messageCounterSamplePeriod() {
        return this.messageCounterSamplePeriod;
    }

    public T messageCounterSamplePeriod(Long value) {
        Long oldValue = this.messageCounterSamplePeriod;
        this.messageCounterSamplePeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageCounterSamplePeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-expiry-scan-period")
    public Long messageExpiryScanPeriod() {
        return this.messageExpiryScanPeriod;
    }

    public T messageExpiryScanPeriod(Long value) {
        Long oldValue = this.messageExpiryScanPeriod;
        this.messageExpiryScanPeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageExpiryScanPeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-expiry-thread-priority")
    public Integer messageExpiryThreadPriority() {
        return this.messageExpiryThreadPriority;
    }

    public T messageExpiryThreadPriority(Integer value) {
        Integer oldValue = this.messageExpiryThreadPriority;
        this.messageExpiryThreadPriority = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageExpiryThreadPriority", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="outgoing-interceptors")
    public List<Map> outgoingInterceptors() {
        return this.outgoingInterceptors;
    }

    public T outgoingInterceptors(List<Map> value) {
        List<Map> oldValue = this.outgoingInterceptors;
        this.outgoingInterceptors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outgoingInterceptors", oldValue, value);
        }
        return (T)this;
    }

    public T outgoingInterceptor(Map value) {
        if (this.outgoingInterceptors == null) {
            this.outgoingInterceptors = new ArrayList<Map>();
        }
        this.outgoingInterceptors.add(value);
        return (T)this;
    }

    public T outgoingInterceptors(Map ... args) {
        this.outgoingInterceptors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="override-in-vm-security")
    public Boolean overrideInVmSecurity() {
        return this.overrideInVmSecurity;
    }

    public T overrideInVmSecurity(Boolean value) {
        Boolean oldValue = this.overrideInVmSecurity;
        this.overrideInVmSecurity = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("overrideInVmSecurity", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="page-max-concurrent-io")
    public Integer pageMaxConcurrentIo() {
        return this.pageMaxConcurrentIo;
    }

    public T pageMaxConcurrentIo(Integer value) {
        Integer oldValue = this.pageMaxConcurrentIo;
        this.pageMaxConcurrentIo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("pageMaxConcurrentIo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="persist-delivery-count-before-delivery")
    public Boolean persistDeliveryCountBeforeDelivery() {
        return this.persistDeliveryCountBeforeDelivery;
    }

    public T persistDeliveryCountBeforeDelivery(Boolean value) {
        Boolean oldValue = this.persistDeliveryCountBeforeDelivery;
        this.persistDeliveryCountBeforeDelivery = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("persistDeliveryCountBeforeDelivery", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="persist-id-cache")
    public Boolean persistIdCache() {
        return this.persistIdCache;
    }

    public T persistIdCache(Boolean value) {
        Boolean oldValue = this.persistIdCache;
        this.persistIdCache = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("persistIdCache", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="persistence-enabled")
    public Boolean persistenceEnabled() {
        return this.persistenceEnabled;
    }

    public T persistenceEnabled(Boolean value) {
        Boolean oldValue = this.persistenceEnabled;
        this.persistenceEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("persistenceEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scheduled-thread-pool-max-size")
    public Integer scheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    public T scheduledThreadPoolMaxSize(Integer value) {
        Integer oldValue = this.scheduledThreadPoolMaxSize;
        this.scheduledThreadPoolMaxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scheduledThreadPoolMaxSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-enabled")
    public Boolean securityEnabled() {
        return this.securityEnabled;
    }

    public T securityEnabled(Boolean value) {
        Boolean oldValue = this.securityEnabled;
        this.securityEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-invalidation-interval")
    public Long securityInvalidationInterval() {
        return this.securityInvalidationInterval;
    }

    public T securityInvalidationInterval(Long value) {
        Long oldValue = this.securityInvalidationInterval;
        this.securityInvalidationInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityInvalidationInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-dump-interval")
    public Long serverDumpInterval() {
        return this.serverDumpInterval;
    }

    public T serverDumpInterval(Long value) {
        Long oldValue = this.serverDumpInterval;
        this.serverDumpInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverDumpInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="started")
    public Boolean started() {
        return this.started;
    }

    public T started(Boolean value) {
        Boolean oldValue = this.started;
        this.started = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("started", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-pool-max-size")
    public Integer threadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    public T threadPoolMaxSize(Integer value) {
        Integer oldValue = this.threadPoolMaxSize;
        this.threadPoolMaxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadPoolMaxSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transaction-timeout")
    public Long transactionTimeout() {
        return this.transactionTimeout;
    }

    public T transactionTimeout(Long value) {
        Long oldValue = this.transactionTimeout;
        this.transactionTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transactionTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transaction-timeout-scan-period")
    public Long transactionTimeoutScanPeriod() {
        return this.transactionTimeoutScanPeriod;
    }

    public T transactionTimeoutScanPeriod(Long value) {
        Long oldValue = this.transactionTimeoutScanPeriod;
        this.transactionTimeoutScanPeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transactionTimeoutScanPeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="version")
    public String version() {
        return this.version;
    }

    public T version(String value) {
        String oldValue = this.version;
        this.version = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("version", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wild-card-routing-enabled")
    public Boolean wildCardRoutingEnabled() {
        return this.wildCardRoutingEnabled;
    }

    public T wildCardRoutingEnabled(Boolean value) {
        Boolean oldValue = this.wildCardRoutingEnabled;
        this.wildCardRoutingEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wildCardRoutingEnabled", oldValue, value);
        }
        return (T)this;
    }

    public static enum JournalType {
        NIO("NIO"),
        ASYNCIO("ASYNCIO");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private JournalType(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class ServerResources {
        @ResourceDocumentation(value="A connector service allows to integrate external components with Apache ActiveMQ Artemis to send and receive messages.")
        @SubresourceInfo(value="connectorService")
        private List<ConnectorService> connectorServices = new ArrayList<ConnectorService>();
        @ResourceDocumentation(value="Defines a way in which remote connections can be made to the ActiveMQ server over HTTP.")
        @SubresourceInfo(value="httpAcceptor")
        private List<HTTPAcceptor> httpAcceptors = new ArrayList<HTTPAcceptor>();
        @ResourceDocumentation(value="Cluster connections group servers into clusters so that messages can be load balanced between the nodes of the cluster.")
        @SubresourceInfo(value="clusterConnection")
        private List<ClusterConnection> clusterConnections = new ArrayList<ClusterConnection>();
        @ResourceDocumentation(value="A broadcast group is the means by which a server broadcasts connectors over the network.")
        @SubresourceInfo(value="broadcastGroup")
        private List<BroadcastGroup> broadcastGroups = new ArrayList<BroadcastGroup>();
        @ResourceDocumentation(value="A Queue.")
        @SubresourceInfo(value="runtimeQueue")
        private List<RuntimeQueue> runtimeQueues = new ArrayList<RuntimeQueue>();
        @ResourceDocumentation(value="An address setting defines some attributes that are defined against an address wildcard rather than a specific queue.")
        @SubresourceInfo(value="addressSetting")
        private List<AddressSetting> addressSettings = new ArrayList<AddressSetting>();
        @ResourceDocumentation(value="Defines a JMS queue.")
        @SubresourceInfo(value="jmsQueue")
        private List<JMSQueue> jmsQueues = new ArrayList<JMSQueue>();
        @ResourceDocumentation(value="Defines a managed connection factory.")
        @SubresourceInfo(value="pooledConnectionFactory")
        private List<PooledConnectionFactory> pooledConnectionFactories = new ArrayList<PooledConnectionFactory>();
        @ResourceDocumentation(value="A messaging resource that allows you to transparently divert messages routed to one address to some other address, without making any changes to any client application logic.")
        @SubresourceInfo(value="divert")
        private List<Divert> diverts = new ArrayList<Divert>();
        @ResourceDocumentation(value="Defines a way in which in-VM connections can be made to the ActiveMQ server.")
        @SubresourceInfo(value="inVmAcceptor")
        private List<InVMAcceptor> inVmAcceptors = new ArrayList<InVMAcceptor>();
        @ResourceDocumentation(value="Multicast group to listen to receive broadcast from other servers announcing their connectors.")
        @SubresourceInfo(value="discoveryGroup")
        private List<DiscoveryGroup> discoveryGroups = new ArrayList<DiscoveryGroup>();
        @ResourceDocumentation(value="Used by a remote client to define how it connects to a server over HTTP.")
        @SubresourceInfo(value="httpConnector")
        private List<HTTPConnector> httpConnectors = new ArrayList<HTTPConnector>();
        @ResourceDocumentation(value="Defines a connection factory.")
        @SubresourceInfo(value="connectionFactory")
        private List<ConnectionFactory> connectionFactories = new ArrayList<ConnectionFactory>();
        @ResourceDocumentation(value="An acceptor defines a way in which connections can be made to the ActiveMQ server.")
        @SubresourceInfo(value="acceptor")
        private List<Acceptor> acceptors = new ArrayList<Acceptor>();
        @ResourceDocumentation(value="Defines a way in which remote connections can be made to the ActiveMQ server.")
        @SubresourceInfo(value="remoteAcceptor")
        private List<RemoteAcceptor> remoteAcceptors = new ArrayList<RemoteAcceptor>();
        @ResourceDocumentation(value="Used by a remote client to define how it connects to a server.")
        @SubresourceInfo(value="remoteConnector")
        private List<RemoteConnector> remoteConnectors = new ArrayList<RemoteConnector>();
        @ResourceDocumentation(value="Used by an in-VM client to define how it connects to a server.")
        @SubresourceInfo(value="inVmConnector")
        private List<InVMConnector> inVmConnectors = new ArrayList<InVMConnector>();
        @ResourceDocumentation(value="Defines a connection factory.")
        @SubresourceInfo(value="legacyConnectionFactory")
        private List<LegacyConnectionFactory> legacyConnectionFactories = new ArrayList<LegacyConnectionFactory>();
        @ResourceDocumentation(value="Makes decisions about which node in a cluster should handle a message with a group id assigned.")
        @SubresourceInfo(value="groupingHandler")
        private List<GroupingHandler> groupingHandlers = new ArrayList<GroupingHandler>();
        @ResourceDocumentation(value="Defines a JMS topic.")
        @SubresourceInfo(value="jmsTopic")
        private List<JMSTopic> jmsTopics = new ArrayList<JMSTopic>();
        @ResourceDocumentation(value="A connector can be used by a client to define how it connects to a server.")
        @SubresourceInfo(value="connector")
        private List<Connector> connectors = new ArrayList<Connector>();
        @ResourceDocumentation(value="A security setting allows sets of permissions to be defined against queues based on their address.")
        @SubresourceInfo(value="securitySetting")
        private List<SecuritySetting> securitySettings = new ArrayList<SecuritySetting>();
        @ResourceDocumentation(value="A runtime-only resource representing a ActiveMQ \"address\". Zero or more queues can be bound to a single address. When a message is routed, it is routed to the set of queues bound to the message's address.")
        @SubresourceInfo(value="coreAddress")
        private List<CoreAddress> coreAddress = new ArrayList<CoreAddress>();
        @ResourceDocumentation(value="The function of a bridge is to consume messages from a source queue, and forward them to a target address, typically on a different ActiveMQ server.")
        @SubresourceInfo(value="bridge")
        private List<Bridge> bridges = new ArrayList<Bridge>();
        @ResourceDocumentation(value="A Queue.")
        @SubresourceInfo(value="queue")
        private List<Queue> queues = new ArrayList<Queue>();
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
        private SharedStoreColocatedHAPolicy sharedStoreColocatedHaPolicy;
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
        private ReplicationMasterHAPolicy replicationMasterHaPolicy;
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
        private SharedStoreMasterHAPolicy sharedStoreMasterHaPolicy;
        @SingletonResource
        @ResourceDocumentation(value="A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.")
        private BindingsDirectoryPath bindingsDirectoryPath;
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
        private ReplicationColocatedHAPolicy replicationColocatedHaPolicy;
        @SingletonResource
        @ResourceDocumentation(value="A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.")
        private JournalDirectoryPath journalDirectoryPath;
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
        private SharedStoreSlaveHAPolicy sharedStoreSlaveHaPolicy;
        @SingletonResource
        @ResourceDocumentation(value="A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.")
        private PagingDirectoryPath pagingDirectoryPath;
        @SingletonResource
        @ResourceDocumentation(value="A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.")
        private LargeMessagesDirectoryPath largeMessagesDirectoryPath;
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
        private LiveOnlyHAPolicy liveOnlyHaPolicy;
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
        private ReplicationSlaveHAPolicy replicationSlaveHaPolicy;

        @Subresource
        public List<ConnectorService> connectorServices() {
            return this.connectorServices;
        }

        public ConnectorService connectorService(String key) {
            return this.connectorServices.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<HTTPAcceptor> httpAcceptors() {
            return this.httpAcceptors;
        }

        public HTTPAcceptor httpAcceptor(String key) {
            return this.httpAcceptors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ClusterConnection> clusterConnections() {
            return this.clusterConnections;
        }

        public ClusterConnection clusterConnection(String key) {
            return this.clusterConnections.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<BroadcastGroup> broadcastGroups() {
            return this.broadcastGroups;
        }

        public BroadcastGroup broadcastGroup(String key) {
            return this.broadcastGroups.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RuntimeQueue> runtimeQueues() {
            return this.runtimeQueues;
        }

        public RuntimeQueue runtimeQueue(String key) {
            return this.runtimeQueues.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<AddressSetting> addressSettings() {
            return this.addressSettings;
        }

        public AddressSetting addressSetting(String key) {
            return this.addressSettings.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<JMSQueue> jmsQueues() {
            return this.jmsQueues;
        }

        public JMSQueue jmsQueue(String key) {
            return this.jmsQueues.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<PooledConnectionFactory> pooledConnectionFactories() {
            return this.pooledConnectionFactories;
        }

        public PooledConnectionFactory pooledConnectionFactory(String key) {
            return this.pooledConnectionFactories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Divert> diverts() {
            return this.diverts;
        }

        public Divert divert(String key) {
            return this.diverts.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<InVMAcceptor> inVmAcceptors() {
            return this.inVmAcceptors;
        }

        public InVMAcceptor inVmAcceptor(String key) {
            return this.inVmAcceptors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<DiscoveryGroup> discoveryGroups() {
            return this.discoveryGroups;
        }

        public DiscoveryGroup discoveryGroup(String key) {
            return this.discoveryGroups.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<HTTPConnector> httpConnectors() {
            return this.httpConnectors;
        }

        public HTTPConnector httpConnector(String key) {
            return this.httpConnectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ConnectionFactory> connectionFactories() {
            return this.connectionFactories;
        }

        public ConnectionFactory connectionFactory(String key) {
            return this.connectionFactories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Acceptor> acceptors() {
            return this.acceptors;
        }

        public Acceptor acceptor(String key) {
            return this.acceptors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RemoteAcceptor> remoteAcceptors() {
            return this.remoteAcceptors;
        }

        public RemoteAcceptor remoteAcceptor(String key) {
            return this.remoteAcceptors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RemoteConnector> remoteConnectors() {
            return this.remoteConnectors;
        }

        public RemoteConnector remoteConnector(String key) {
            return this.remoteConnectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<InVMConnector> inVmConnectors() {
            return this.inVmConnectors;
        }

        public InVMConnector inVmConnector(String key) {
            return this.inVmConnectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<LegacyConnectionFactory> legacyConnectionFactories() {
            return this.legacyConnectionFactories;
        }

        public LegacyConnectionFactory legacyConnectionFactory(String key) {
            return this.legacyConnectionFactories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<GroupingHandler> groupingHandlers() {
            return this.groupingHandlers;
        }

        public GroupingHandler groupingHandler(String key) {
            return this.groupingHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<JMSTopic> jmsTopics() {
            return this.jmsTopics;
        }

        public JMSTopic jmsTopic(String key) {
            return this.jmsTopics.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Connector> connectors() {
            return this.connectors;
        }

        public Connector connector(String key) {
            return this.connectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<SecuritySetting> securitySettings() {
            return this.securitySettings;
        }

        public SecuritySetting securitySetting(String key) {
            return this.securitySettings.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<CoreAddress> coreAddress() {
            return this.coreAddress;
        }

        public CoreAddress coreAddress(String key) {
            return this.coreAddress.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Bridge> bridges() {
            return this.bridges;
        }

        public Bridge bridge(String key) {
            return this.bridges.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Queue> queues() {
            return this.queues;
        }

        public Queue queue(String key) {
            return this.queues.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public SharedStoreColocatedHAPolicy sharedStoreColocatedHaPolicy() {
            return this.sharedStoreColocatedHaPolicy;
        }

        @Subresource
        public ReplicationMasterHAPolicy replicationMasterHaPolicy() {
            return this.replicationMasterHaPolicy;
        }

        @Subresource
        public SharedStoreMasterHAPolicy sharedStoreMasterHaPolicy() {
            return this.sharedStoreMasterHaPolicy;
        }

        @Subresource
        public BindingsDirectoryPath bindingsDirectoryPath() {
            return this.bindingsDirectoryPath;
        }

        @Subresource
        public ReplicationColocatedHAPolicy replicationColocatedHaPolicy() {
            return this.replicationColocatedHaPolicy;
        }

        @Subresource
        public JournalDirectoryPath journalDirectoryPath() {
            return this.journalDirectoryPath;
        }

        @Subresource
        public SharedStoreSlaveHAPolicy sharedStoreSlaveHaPolicy() {
            return this.sharedStoreSlaveHaPolicy;
        }

        @Subresource
        public PagingDirectoryPath pagingDirectoryPath() {
            return this.pagingDirectoryPath;
        }

        @Subresource
        public LargeMessagesDirectoryPath largeMessagesDirectoryPath() {
            return this.largeMessagesDirectoryPath;
        }

        @Subresource
        public LiveOnlyHAPolicy liveOnlyHaPolicy() {
            return this.liveOnlyHaPolicy;
        }

        @Subresource
        public ReplicationSlaveHAPolicy replicationSlaveHaPolicy() {
            return this.replicationSlaveHaPolicy;
        }
    }
}

