/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/divert=*")
@ResourceType(value="divert")
public class Divert<T extends Divert<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Address to divert from")
    private String divertAddress;
    @AttributeDocumentation(value="Whether the divert is exclusive, meaning that the message is diverted to the new address, and does not go to the old address at all.")
    private Boolean exclusive;
    @AttributeDocumentation(value="An optional filter string. If specified then only messages which match the filter expression specified will be diverted. The filter string follows the ActiveMQ filter expression syntax described in the ActiveMQ documentation.")
    private String filter;
    @AttributeDocumentation(value="Address to divert to")
    private String forwardingAddress;
    @AttributeDocumentation(value="Routing name of the divert")
    private String routingName;
    @AttributeDocumentation(value="The name of a class used to transform the message's body or properties before it is diverted.")
    private String transformerClassName;

    public Divert(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="divert-address")
    public String divertAddress() {
        return this.divertAddress;
    }

    public T divertAddress(String value) {
        String oldValue = this.divertAddress;
        this.divertAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("divertAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exclusive")
    public Boolean exclusive() {
        return this.exclusive;
    }

    public T exclusive(Boolean value) {
        Boolean oldValue = this.exclusive;
        this.exclusive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exclusive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter")
    public String filter() {
        return this.filter;
    }

    public T filter(String value) {
        String oldValue = this.filter;
        this.filter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="forwarding-address")
    public String forwardingAddress() {
        return this.forwardingAddress;
    }

    public T forwardingAddress(String value) {
        String oldValue = this.forwardingAddress;
        this.forwardingAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("forwardingAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="routing-name")
    public String routingName() {
        return this.routingName;
    }

    public T routingName(String value) {
        String oldValue = this.routingName;
        this.routingName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("routingName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transformer-class-name")
    public String transformerClassName() {
        return this.transformerClassName;
    }

    public T transformerClassName(String value) {
        String oldValue = this.transformerClassName;
        this.transformerClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transformerClassName", oldValue, value);
        }
        return (T)this;
    }
}

