/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.modcluster.proxy.load_provider;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=modcluster/proxy=*/load-provider=dynamic/custom-load-metric=*")
@ResourceType(value="custom-load-metric")
public class CustomLoadMetric<T extends CustomLoadMetric<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Maximum capacity of the metric used to normalize the load values from a metric which require explicit capacity.")
    private Double capacity;
    @AttributeDocumentation(value="Class name to use to construct a load metric from.")
    private String attributeClass;
    @AttributeDocumentation(value="Module name from which to load the load metric class.")
    private String module;
    @AttributeDocumentation(value="Properties to apply on a loaded metric instance.")
    private Map property;
    @AttributeDocumentation(value="Number indicating the significance of a metric with respect to the other metrics. For example, a metric of weight 2 will have twice the impact on the overall load factor than a metric of weight 1.")
    private Integer weight;

    public CustomLoadMetric(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="capacity")
    public Double capacity() {
        return this.capacity;
    }

    public T capacity(Double value) {
        Double oldValue = this.capacity;
        this.capacity = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacity", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="class")
    public String attributeClass() {
        return this.attributeClass;
    }

    public T attributeClass(String value) {
        String oldValue = this.attributeClass;
        this.attributeClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="property")
    public Map property() {
        return this.property;
    }

    public T property(Map value) {
        Map oldValue = this.property;
        this.property = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("property", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.property == null) {
            this.property = new HashMap();
        }
        this.property.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="weight")
    public Integer weight() {
        return this.weight;
    }

    public T weight(Integer value) {
        Integer oldValue = this.weight;
        this.weight = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("weight", oldValue, value);
        }
        return (T)this;
    }
}

