/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain.mapping;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=security/security-domain=*/mapping=classic/mapping-module=*")
@ResourceType(value="mapping-module")
public class MappingModule<T extends MappingModule<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Class name of the module to be instantiated.")
    private String code;
    @AttributeDocumentation(value="Name of JBoss Module where the mapping module code is located.")
    private String module;
    @AttributeDocumentation(value="List of module options containing a name/value pair.")
    private Map moduleOptions;
    @AttributeDocumentation(value="Type of mapping this module performs. Allowed values are principal, role, attribute or credential..")
    private String type;

    public MappingModule(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="code")
    public String code() {
        return this.code;
    }

    public T code(String value) {
        String oldValue = this.code;
        this.code = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("code", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module-options")
    public Map moduleOptions() {
        return this.moduleOptions;
    }

    public T moduleOptions(Map value) {
        Map oldValue = this.moduleOptions;
        this.moduleOptions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("moduleOptions", oldValue, value);
        }
        return (T)this;
    }

    public T moduleOption(String key, Object value) {
        if (this.moduleOptions == null) {
            this.moduleOptions = new HashMap();
        }
        this.moduleOptions.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }
}

