/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=undertow/byte-buffer-pool=*")
@ResourceType(value="byte-buffer-pool")
public class ByteBufferPool<T extends ByteBufferPool<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The size of the buffer")
    private Integer bufferSize;
    @AttributeDocumentation(value="If this is true the buffer pool will use direct buffers, this is recommended for best performance")
    private Boolean direct;
    @AttributeDocumentation(value="The percentage of buffers that will be allocated with a leak detector. This should only be larger than zero if you are experiencing issues with buffers leaking.")
    private Integer leakDetectionPercent;
    @AttributeDocumentation(value="The maximum amount of buffers to keep in the pool. If more buffers are required at runtime they will be allocated dynamically. Setting this to zero effectively disables pooling.")
    private Integer maxPoolSize;
    @AttributeDocumentation(value="The maximum number of buffers to cache on each thread. The actual number may be lower depending on the calculated usage pattern.")
    private Integer threadLocalCacheSize;

    public ByteBufferPool(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="buffer-size")
    public Integer bufferSize() {
        return this.bufferSize;
    }

    public T bufferSize(Integer value) {
        Integer oldValue = this.bufferSize;
        this.bufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="direct")
    public Boolean direct() {
        return this.direct;
    }

    public T direct(Boolean value) {
        Boolean oldValue = this.direct;
        this.direct = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("direct", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="leak-detection-percent")
    public Integer leakDetectionPercent() {
        return this.leakDetectionPercent;
    }

    public T leakDetectionPercent(Integer value) {
        Integer oldValue = this.leakDetectionPercent;
        this.leakDetectionPercent = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("leakDetectionPercent", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-pool-size")
    public Integer maxPoolSize() {
        return this.maxPoolSize;
    }

    public T maxPoolSize(Integer value) {
        Integer oldValue = this.maxPoolSize;
        this.maxPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-local-cache-size")
    public Integer threadLocalCacheSize() {
        return this.threadLocalCacheSize;
    }

    public T threadLocalCacheSize(Integer value) {
        Integer oldValue = this.threadLocalCacheSize;
        this.threadLocalCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadLocalCacheSize", oldValue, value);
        }
        return (T)this;
    }
}

