/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;

public abstract class AbstractNetworkExtension<T>
implements Extension {
    protected final ConfigView configView;

    protected AbstractNetworkExtension(ConfigView configView) {
        this.configView = configView;
    }

    protected abstract void applyConfiguration(T var1);

    void process(@Observes ProcessProducer<?, T> p, BeanManager beanManager) throws Exception {
        p.setProducer(this.producer(p.getProducer()));
    }

    protected void applyConfiguration(ConfigKey key, Consumer<Object> consumer) {
        Object value = this.configView.valueOf(key);
        if (value != null) {
            consumer.accept(value);
        }
    }

    protected Producer<T> producer(final Producer<T> delegate) {
        return new Producer<T>(){

            public T produce(CreationalContext<T> ctx) {
                Object instance = delegate.produce(ctx);
                AbstractNetworkExtension.this.applyConfiguration(instance);
                return instance;
            }

            public void dispose(T instance) {
                delegate.dispose(instance);
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return delegate.getInjectionPoints();
            }
        };
    }
}

