/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.Resolver;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;

@ApplicationScoped
public class ConfigurationValueProducer {
    @Inject
    private ConfigView configView;

    @Produces
    @ConfigurationValue(value="")
    @Dependent
    Resolver<String> produceResolver(InjectionPoint injectionPoint) {
        return this.resolver(injectionPoint);
    }

    @Produces
    @ConfigurationValue(value="")
    @Dependent
    String produceStringConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, String.class);
    }

    @Produces
    @ConfigurationValue(value="")
    @Dependent
    Integer produceIntegerConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Integer.class);
    }

    @Produces
    @Dependent
    @ConfigurationValue(value="")
    Boolean produceBooleanConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Boolean.class);
    }

    @ConfigurationValue(value="")
    @Dependent
    @Produces
    Long produceLongConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Long.class);
    }

    @ConfigurationValue(value="")
    @Dependent
    @Produces
    Float produceFloatConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Float.class);
    }

    @ConfigurationValue(value="")
    @Dependent
    @Produces
    Double produceDoubleConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Double.class);
    }

    @ConfigurationValue(value="")
    @Dependent
    @Produces
    <T> Optional<T> produceOptionalConfigValue(InjectionPoint injectionPoint) {
        Class valueType;
        Type type = injectionPoint.getAnnotated().getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = this.unwrapType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        return Optional.ofNullable(this.resolve(injectionPoint, valueType));
    }

    private <T> Class<T> unwrapType(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    private <T> T resolve(InjectionPoint injectionPoint, Class<T> target) {
        Resolver<String> resolver = this.resolver(injectionPoint);
        try {
            return (T)(resolver != null ? resolver.as(target).getValue() : null);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private Resolver<String> resolver(InjectionPoint injectionPoint) {
        String name = this.getName(injectionPoint);
        if (name == null || name.isEmpty() || this.configView == null) {
            return null;
        }
        return this.configView.resolve(name);
    }

    private String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigurationValue.class)) continue;
            return ((ConfigurationValue)qualifier).value();
        }
        return null;
    }
}

